/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorCreateException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptorLoader;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfiguration;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderConfigurationLoader;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.artifact.api.descriptor.LoaderNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
@NoExtend
public abstract class AbstractArtifactDescriptorFactory<M extends AbstractMuleArtifactModel, T extends ArtifactDescriptor>
implements ArtifactDescriptorFactory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArtifactDescriptorFactory.class);
    public static final String ARTIFACT_DESCRIPTOR_DOES_NOT_EXISTS_ERROR = "Artifact descriptor does not exists: ";
    protected final DescriptorLoaderRepository descriptorLoaderRepository;
    private final ArtifactDescriptorValidator artifactDescriptorValidator;

    public AbstractArtifactDescriptorFactory(DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        Preconditions.checkArgument(descriptorLoaderRepository != null, "descriptorLoaderRepository cannot be null");
        this.descriptorLoaderRepository = descriptorLoaderRepository;
        this.artifactDescriptorValidator = artifactDescriptorValidatorBuilder.validateMinMuleVersion().validateMuleProduct().validateVersionFormat().validateSupportedJavaVersions().build();
    }

    @Override
    public T create(File artifactFolder, Optional<Properties> deploymentProperties) throws ArtifactDescriptorCreateException {
        M artifactModel = this.createArtifactModel(artifactFolder);
        return this.createArtifact(artifactFolder, deploymentProperties, artifactModel);
    }

    public T createArtifact(File artifactFolder, Optional<Properties> deploymentProperties, M artifactModel) {
        T artifactDescriptor = this.loadFromJsonDescriptor(artifactFolder, artifactModel, deploymentProperties);
        return artifactDescriptor;
    }

    public M createArtifactModel(File artifactFolder) {
        File artifactJsonFile = new File(artifactFolder, ArtifactDescriptor.MULE_ARTIFACT_FOLDER + File.separator + this.getDescriptorFileName());
        if (!artifactJsonFile.exists()) {
            throw new ArtifactDescriptorCreateException(ARTIFACT_DESCRIPTOR_DOES_NOT_EXISTS_ERROR + artifactJsonFile);
        }
        return this.loadModelFromJson(this.getDescriptorContent(artifactJsonFile));
    }

    protected abstract ArtifactType getArtifactType();

    protected final T loadFromJsonDescriptor(File artifactLocation, M artifactModel, Optional<Properties> deploymentProperties) {
        ((AbstractMuleArtifactModel)artifactModel).validateModel(artifactLocation.getName());
        T descriptor = this.createArtifactDescriptor(artifactLocation, ((AbstractMuleArtifactModel)artifactModel).getName(), deploymentProperties);
        if (artifactLocation.isDirectory()) {
            ((ArtifactDescriptor)descriptor).setRootFolder(artifactLocation);
        }
        BundleDescriptor bundleDescriptor = this.getBundleDescriptor(artifactLocation, artifactModel, deploymentProperties);
        ((ArtifactDescriptor)descriptor).setBundleDescriptor(bundleDescriptor);
        ((ArtifactDescriptor)descriptor).setMinMuleVersion(new MuleVersion(((AbstractMuleArtifactModel)artifactModel).getMinMuleVersion()));
        ((ArtifactDescriptor)descriptor).setRequiredProduct(((AbstractMuleArtifactModel)artifactModel).getRequiredProduct());
        ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration(artifactLocation, deploymentProperties, ((AbstractMuleArtifactModel)artifactModel).getClassLoaderModelLoaderDescriptor(), bundleDescriptor);
        ((ArtifactDescriptor)descriptor).setClassLoaderConfiguration(classLoaderConfiguration);
        this.doDescriptorConfig(artifactModel, descriptor, artifactLocation);
        this.artifactDescriptorValidator.validate((ArtifactDescriptor)descriptor);
        return descriptor;
    }

    protected M loadModelFromJson(String jsonString) {
        try {
            return this.deserializeArtifactModel(jsonString);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot deserialize artifact descriptor from: " + jsonString);
        }
    }

    protected abstract AbstractMuleArtifactModelJsonSerializer<M> getMuleArtifactModelJsonSerializer();

    protected abstract void doDescriptorConfig(M var1, T var2, File var3);

    protected abstract T createArtifactDescriptor(File var1, String var2, Optional<Properties> var3);

    private String getDescriptorFileName() {
        return "mule-artifact.json";
    }

    private String getDescriptorContent(File jsonFile) {
        String string;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading artifact descriptor from '{}'..." + jsonFile.getAbsolutePath());
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(jsonFile));
        try {
            string = IOUtils.toString(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not read extension describer on artifact '%s'", jsonFile.getAbsolutePath()), e);
            }
        }
        ((InputStream)stream).close();
        return string;
    }

    protected ClassLoaderConfiguration getClassLoaderConfiguration(File artifactFolder, Optional<Properties> deploymentProperties, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, BundleDescriptor bundleDescriptor) {
        ClassLoaderConfiguration classLoaderConfiguration;
        ClassLoaderConfigurationLoader classLoaderConfigurationLoader;
        try {
            classLoaderConfigurationLoader = this.descriptorLoaderRepository.get(classLoaderModelLoaderDescriptor.getId(), this.getArtifactType(), ClassLoaderConfigurationLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(AbstractArtifactDescriptorFactory.invalidClassLoaderModelIdError(artifactFolder, classLoaderModelLoaderDescriptor));
        }
        try {
            classLoaderConfiguration = (ClassLoaderConfiguration)classLoaderConfigurationLoader.load(artifactFolder, this.getClassLoaderConfigurationAttributes(deploymentProperties, classLoaderModelLoaderDescriptor, bundleDescriptor), this.getArtifactType());
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException(e);
        }
        return classLoaderConfiguration;
    }

    protected Map<String, Object> getClassLoaderConfigurationAttributes(Optional<Properties> deploymentProperties, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, BundleDescriptor bundleDescriptor) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(classLoaderModelLoaderDescriptor.getAttributes());
        attributes.put(BundleDescriptor.class.getName(), bundleDescriptor);
        return Collections.unmodifiableMap(attributes);
    }

    protected BundleDescriptor getBundleDescriptor(File appFolder, M artifactModel, Optional<Properties> deploymentProperties) {
        BundleDescriptorLoader bundleDescriptorLoader;
        try {
            bundleDescriptorLoader = this.descriptorLoaderRepository.get(((AbstractMuleArtifactModel)artifactModel).getBundleDescriptorLoader().getId(), this.getArtifactType(), BundleDescriptorLoader.class);
        }
        catch (LoaderNotFoundException e) {
            throw new ArtifactDescriptorCreateException(AbstractArtifactDescriptorFactory.invalidBundleDescriptorLoaderIdError(appFolder, ((AbstractMuleArtifactModel)artifactModel).getBundleDescriptorLoader()));
        }
        try {
            return (BundleDescriptor)bundleDescriptorLoader.load(appFolder, this.getBundleDescriptorAttributes(((AbstractMuleArtifactModel)artifactModel).getBundleDescriptorLoader(), deploymentProperties), this.getArtifactType());
        }
        catch (InvalidDescriptorLoaderException e) {
            throw new ArtifactDescriptorCreateException(e);
        }
    }

    protected Map<String, Object> getBundleDescriptorAttributes(MuleArtifactLoaderDescriptor bundleDescriptorLoader, Optional<Properties> deploymentPropertiesOptional) {
        return bundleDescriptorLoader.getAttributes();
    }

    private M deserializeArtifactModel(String jsonString) throws IOException {
        return this.getMuleArtifactModelJsonSerializer().deserialize(jsonString);
    }

    public static String invalidClassLoaderModelIdError(File artifactFolder, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor) {
        return String.format("The identifier '%s' for a class loader model descriptor is not supported (error found while reading artifact '%s')", classLoaderModelLoaderDescriptor.getId(), artifactFolder.getAbsolutePath());
    }

    public static String invalidBundleDescriptorLoaderIdError(File artifactFolder, MuleArtifactLoaderDescriptor bundleDescriptorLoader) {
        return String.format("The identifier '%s' for a bundle descriptor loader is not supported (error found while reading artifact '%s')", bundleDescriptorLoader.getId(), artifactFolder.getAbsolutePath());
    }
}

