/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.artifact.ArtifactCoordinates;

public final class BundleDescriptor
implements ArtifactCoordinates {
    public static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private static final String STRINGARTIFACT_FILENAME_SEPARATOR = "-";
    private String groupId;
    private String artifactId;
    private String version;
    private String baseVersion;
    private String type = "jar";
    private Optional<String> classifier = Optional.empty();
    private volatile String artifactFileName;
    private Map<String, Object> metadata = Collections.emptyMap();

    public static Builder builder() {
        return new Builder();
    }

    private BundleDescriptor() {
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Optional<String> getClassifier() {
        return this.classifier;
    }

    public boolean isPlugin() {
        return this.classifier.map(classifier -> classifier.equals(MULE_PLUGIN_CLASSIFIER)).orElse(false);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleDescriptor that = (BundleDescriptor)o;
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        if (!this.version.equals(that.version)) {
            return false;
        }
        if (!this.classifier.equals(that.classifier)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.classifier.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "BundleDescriptor{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', baseVersion='" + this.baseVersion + "', version='" + this.version + "', type='" + this.type + "', classifier=" + this.classifier + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getArtifactFileName() {
        if (this.artifactFileName == null) {
            BundleDescriptor bundleDescriptor = this;
            synchronized (bundleDescriptor) {
                if (this.artifactFileName == null) {
                    Object fileName = this.artifactId;
                    if (this.getVersion() != null) {
                        fileName = (String)fileName + STRINGARTIFACT_FILENAME_SEPARATOR + this.getVersion();
                    }
                    if (this.classifier.isPresent()) {
                        fileName = (String)fileName + STRINGARTIFACT_FILENAME_SEPARATOR + this.classifier.get();
                    }
                    this.artifactFileName = fileName;
                }
            }
        }
        return this.artifactFileName;
    }

    public static class Builder {
        private static final String ARTIFACT_ID = "artifact id";
        private static final String VERSION = "version";
        private static final String BASE_VERSION = "base version";
        private static final String GROUP_ID = "group id";
        private static final String TYPE = "type";
        private static final String CLASSIFIER = "classifier";
        private static final String REQUIRED_FIELD_NOT_FOUND_TEMPLATE = "bundle cannot be created with null or empty %s";
        private final BundleDescriptor bundleDependency = new BundleDescriptor();

        public Builder setGroupId(String groupId) {
            this.bundleDependency.groupId = this.validateIsNotEmpty(groupId, GROUP_ID);
            return this;
        }

        public Builder setArtifactId(String artifactId) {
            this.bundleDependency.artifactId = this.validateIsNotEmpty(artifactId, ARTIFACT_ID);
            return this;
        }

        public Builder setVersion(String version) {
            this.bundleDependency.version = this.validateIsNotEmpty(version, VERSION);
            return this;
        }

        public Builder setBaseVersion(String baseVersion) {
            this.bundleDependency.baseVersion = this.validateIsNotEmpty(baseVersion, BASE_VERSION);
            return this;
        }

        public Builder setType(String type) {
            this.bundleDependency.type = this.validateIsNotEmpty(type, TYPE);
            return this;
        }

        public Builder setClassifier(String classifier) {
            this.bundleDependency.classifier = Optional.ofNullable(classifier);
            return this;
        }

        public Builder setMetadata(Map<String, Object> metadata) {
            this.bundleDependency.metadata = Objects.requireNonNull(metadata);
            return this;
        }

        public BundleDescriptor build() {
            this.validateIsNotEmpty(this.bundleDependency.groupId, GROUP_ID);
            this.validateIsNotEmpty(this.bundleDependency.artifactId, ARTIFACT_ID);
            this.validateIsNotEmpty(this.bundleDependency.version, VERSION);
            return this.bundleDependency;
        }

        private String getNullFieldMessage(String field) {
            return String.format(REQUIRED_FIELD_NOT_FOUND_TEMPLATE, field);
        }

        private String validateIsNotEmpty(String value, String fieldId) {
            if (value == null || value.equals("")) {
                throw new IllegalStateException(this.getNullFieldMessage(fieldId));
            }
            return value;
        }
    }
}

