/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;

public class ExpressionLanguageTransformationValueResolver
implements ValueResolver {
    private static final String PAYLOAD_IDENTIFIER = "payload";
    private static final String PAYLOAD_EXPRESSION = "#[payload]";
    private final Class expectedType;
    private final ValueResolver valueResolverDelegate;
    private final ExpressionLanguage expressionLanguage;

    public ExpressionLanguageTransformationValueResolver(ValueResolver valueResolverDelegate, Class expectedType, ExpressionLanguage expressionLanguage) {
        this.expectedType = expectedType == null ? Object.class : expectedType;
        this.valueResolverDelegate = valueResolverDelegate;
        this.expressionLanguage = expressionLanguage;
    }

    public Object resolve(ValueResolvingContext context) throws MuleException {
        Object resolvedValue = this.valueResolverDelegate.resolve(context);
        if (ClassUtils.isInstance(this.expectedType, TypedValue.unwrap(resolvedValue))) {
            return resolvedValue;
        }
        return this.expressionLanguage.evaluate(PAYLOAD_EXPRESSION, DataType.fromType(this.expectedType), BindingContext.builder().addBinding(PAYLOAD_IDENTIFIER, TypedValue.of(resolvedValue)).build()).getValue();
    }

    @Override
    public boolean isDynamic() {
        return this.valueResolverDelegate.isDynamic();
    }
}

