/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.display;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public final class LayoutModel {
    public static final int DEFAULT_ORDER = -1;
    private boolean password = false;
    private boolean text = false;
    private boolean query = false;
    private Integer order = null;
    private String tabName = null;

    public static LayoutModelBuilder builder() {
        return new LayoutModelBuilder();
    }

    public static LayoutModelBuilder builderFrom(LayoutModel template) {
        return new LayoutModelBuilder(template);
    }

    private LayoutModel() {
    }

    public boolean isPassword() {
        return this.password;
    }

    public boolean isText() {
        return this.text;
    }

    public boolean isQuery() {
        return this.query;
    }

    public Optional<Integer> getOrder() {
        return Optional.ofNullable(this.order);
    }

    public Optional<String> getTabName() {
        return Optional.ofNullable(this.tabName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LayoutModel) {
            LayoutModel other = (LayoutModel)obj;
            return other.isText() == this.isText() && other.isQuery() == this.isQuery() && other.isPassword() == this.isPassword() && Objects.equals(other.getOrder(), this.getOrder()) && Objects.equals(other.getTabName(), this.getTabName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.text, this.query, this.password, this.order, this.tabName);
    }

    public static final class LayoutModelBuilder {
        private final LayoutModel product = new LayoutModel();

        private LayoutModelBuilder() {
        }

        private LayoutModelBuilder(LayoutModel template) {
            if (template != null) {
                this.product.order = template.order;
                this.product.text = template.text;
                this.product.query = template.query;
                this.product.password = template.password;
                this.product.tabName = template.tabName;
            }
        }

        public LayoutModelBuilder asPassword() {
            this.product.password = true;
            return this;
        }

        public LayoutModelBuilder asText() {
            this.product.text = true;
            return this;
        }

        public LayoutModelBuilder asQuery() {
            this.product.query = true;
            return this.asText();
        }

        public LayoutModelBuilder tabName(String tabName) {
            this.product.tabName = this.orNull(tabName, t -> !StringUtils.isEmpty((CharSequence)t));
            return this;
        }

        public LayoutModelBuilder order(int order) {
            this.product.order = this.orNull(order, o -> o != -1);
            return this;
        }

        private <T> T orNull(T value, Predicate<T> accept) {
            return (T)(accept.test(value) ? value : null);
        }

        public LayoutModel build() {
            return this.product;
        }
    }
}

