/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.event;

import java.util.Optional;
import java.util.OptionalLong;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.runtime.operation.Result;

@NoExtend
public class EventedResult<T, A>
extends Result<T, A> {
    protected final CoreEvent event;

    protected EventedResult(CoreEvent event) {
        this.event = event;
    }

    public static <T, A> EventedResult<T, A> from(CoreEvent event) {
        return new EventedResult<T, A>(event);
    }

    public CoreEvent getEvent() {
        return this.event;
    }

    @Override
    public Result.Builder<T, A> copy() {
        final CoreEvent.Builder product = CoreEvent.builder(this.event);
        final Message.Builder message = Message.builder(this.event.getMessage());
        return new Result.Builder<T, A>(){

            @Override
            public Result.Builder<T, A> output(T output) {
                message.payload(TypedValue.of(output));
                return this;
            }

            @Override
            public Result.Builder<T, A> attributes(A attributes) {
                message.attributes(TypedValue.of(attributes));
                return this;
            }

            @Override
            public Result.Builder<T, A> mediaType(MediaType mediaType) {
                message.mediaType(mediaType);
                return this;
            }

            @Override
            public Result.Builder<T, A> attributesMediaType(MediaType mediaType) {
                message.attributesMediaType(mediaType);
                return this;
            }

            @Override
            public Result<T, A> build() {
                return EventedResult.from(product.message(message.build()).build());
            }
        };
    }

    @Override
    public T getOutput() {
        return this.event.getMessage().getPayload().getValue();
    }

    @Override
    public Optional<A> getAttributes() {
        return Optional.ofNullable(this.event.getMessage().getAttributes().getValue());
    }

    @Override
    public Optional<MediaType> getMediaType() {
        return Optional.ofNullable(this.event.getMessage().getPayload().getDataType().getMediaType());
    }

    @Override
    public Optional<MediaType> getAttributesMediaType() {
        return Optional.ofNullable(this.event.getMessage().getAttributes().getDataType().getMediaType());
    }

    @Override
    public Optional<Long> getLength() {
        return this.event.getMessage().getPayload().getLength();
    }

    @Override
    public OptionalLong getByteLength() {
        return this.event.getMessage().getPayload().getByteLength();
    }
}

