/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.IdempotentDeclarationEnricherWalkDelegate;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;
import org.mule.runtime.extension.internal.property.TargetModelProperty;

public final class TargetParameterDeclarationEnricher
implements WalkingDeclarationEnricher {
    private static final DefaultStringType stringType = BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().build();
    private static final Map<String, Set<String>> BLOCK_LIST;

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        String extensionName = ((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration()).getName();
        return Optional.of(new WalkDelegateDelegateDeclaration(BLOCK_LIST.getOrDefault(extensionName, Collections.emptySet())));
    }

    private static void addTargetValueParameter(OperationDeclaration operationDeclaration, ParameterDeclaration targetValueParameter) {
        operationDeclaration.getParameterGroup("Output").addParameter(targetValueParameter);
    }

    private static void addTargetParameter(OperationDeclaration operationDeclaration, ParameterDeclaration targetParameter) {
        operationDeclaration.getParameterGroup("Output").addParameter(targetParameter);
    }

    private static boolean definesTargetValueParameter(OperationDeclaration operationDeclaration) {
        return operationDeclaration.getParameterGroup("Output").getParameters().stream().anyMatch(parameterDeclaration -> parameterDeclaration.getName().equals("targetValue"));
    }

    private static boolean definesTargetParameter(OperationDeclaration operationDeclaration) {
        return operationDeclaration.getParameterGroup("Output").getParameters().stream().anyMatch(parameterDeclaration -> parameterDeclaration.getName().equals("target"));
    }

    static /* synthetic */ DefaultStringType access$100() {
        return stringType;
    }

    static {
        SmallMap<String, Set<String>> block = new SmallMap<String, Set<String>>();
        block.put("ee", Collections.singleton("transform"));
        BLOCK_LIST = Collections.unmodifiableMap(block);
    }

    private static class WalkDelegateDelegateDeclaration
    extends IdempotentDeclarationEnricherWalkDelegate {
        private final Set<String> blockedOperationsNames;
        private final MetadataType attributeType = TargetParameterDeclarationEnricher.access$100();
        private final MetadataType targetValue = TargetParameterDeclarationEnricher.access$100();

        private WalkDelegateDelegateDeclaration(Set<String> blockedOperationsNames) {
            this.blockedOperationsNames = blockedOperationsNames;
        }

        @Override
        protected void onOperation(OperationDeclaration declaration) {
            if (this.blockedOperationsNames.contains(declaration.getName())) {
                return;
            }
            MetadataType outputType = declaration.getOutput().getType();
            if (outputType == null) {
                throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' does not specify an output type", declaration.getName()));
            }
            if (!(outputType instanceof VoidType)) {
                this.enrichWithTargetParameterDeclaration(declaration);
                this.enrichWithTargetValueParameterDeclaration(declaration);
            }
        }

        private void enrichWithTargetParameterDeclaration(OperationDeclaration operationDeclaration) {
            if (!TargetParameterDeclarationEnricher.definesTargetParameter(operationDeclaration)) {
                ParameterDeclaration targetParameterDeclaration = new ParameterDeclaration("target");
                targetParameterDeclaration.setDescription("The name of a variable on which the operation's output will be placed");
                targetParameterDeclaration.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
                targetParameterDeclaration.setRequired(false);
                targetParameterDeclaration.setParameterRole(ParameterRole.BEHAVIOUR);
                targetParameterDeclaration.setType(this.attributeType, false);
                targetParameterDeclaration.setDisplayModel(DisplayModel.builder().displayName("Target Variable").build());
                targetParameterDeclaration.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                TargetParameterDeclarationEnricher.addTargetParameter(operationDeclaration, targetParameterDeclaration);
            }
        }

        private void enrichWithTargetValueParameterDeclaration(OperationDeclaration operationDeclaration) {
            if (!TargetParameterDeclarationEnricher.definesTargetValueParameter(operationDeclaration)) {
                ParameterDeclaration targetValueParameterDeclaration = new ParameterDeclaration("targetValue");
                targetValueParameterDeclaration.setDescription("An expression that will be evaluated against the operation's output and the outcome of that expression will be stored in the target variable");
                targetValueParameterDeclaration.setExpressionSupport(ExpressionSupport.REQUIRED);
                targetValueParameterDeclaration.setRequired(false);
                targetValueParameterDeclaration.setDefaultValue("#[payload]");
                targetValueParameterDeclaration.setParameterRole(ParameterRole.BEHAVIOUR);
                targetValueParameterDeclaration.setType(this.targetValue, false);
                targetValueParameterDeclaration.setDisplayModel(DisplayModel.builder().displayName("Target Value").build());
                targetValueParameterDeclaration.setLayoutModel(LayoutModel.builder().tabName("Advanced").build());
                targetValueParameterDeclaration.addModelProperty(new TargetModelProperty());
                TargetParameterDeclarationEnricher.addTargetValueParameter(operationDeclaration, targetValueParameterDeclaration);
            }
        }
    }
}

