/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.cache.CacheIdBuilderAdapter;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.internal.cache.MetadataCacheIdBuilderAdapter;
import org.mule.runtime.metadata.internal.types.AttributesMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.ComponentParameterizationInputMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.KeysMetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.MetadataResolutionTypeInformation;
import org.mule.runtime.metadata.internal.types.OutputMetadataResolutionTypeInformation;

public class ComponentParameterizationBasedMetadataCacheIdGenerator
implements ComponentParameterizationMetadataCacheIdGenerator {
    private static final String CONFIG_ATTRIBUTE_NAME = "config-ref";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private final ConfigurationMetadataCacheIdGenerator configIdGenerator;

    public ComponentParameterizationBasedMetadataCacheIdGenerator(ConfigurationMetadataCacheIdGenerator configIdGenerator) {
        this.configIdGenerator = configIdGenerator;
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentOutputMetadata(ComponentParameterization<?> parameterization) {
        if (parameterization.getModel() instanceof HasOutputModel) {
            return this.doResolveType(parameterization, new OutputMetadataResolutionTypeInformation(parameterization));
        }
        return Optional.empty();
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentAttributesMetadata(ComponentParameterization<?> parameterization) {
        if (parameterization.getModel() instanceof HasOutputModel) {
            return this.doResolveType(parameterization, new AttributesMetadataResolutionTypeInformation(parameterization));
        }
        return Optional.empty();
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentInputMetadata(ComponentParameterization<?> parameterization, String parameterName) {
        Preconditions.checkArgument(parameterization.getModel().getAllParameterModels().stream().anyMatch(parameterModel -> parameterModel.getName().equals(parameterName)), () -> "Cannot generate an Input Cache Key for component '" + parameterization.getModel().getName() + "' since it does not have a parameter named " + parameterName);
        return this.doResolveType(parameterization, new ComponentParameterizationInputMetadataResolutionTypeInformation(parameterization, parameterName));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentInputMetadata(ComponentParameterization<?> parameterization, String parameterGroupName, String parameterName) {
        Preconditions.checkArgument(parameterization.getParameter(parameterGroupName, parameterName) != null, () -> "Cannot generate an Input Cache Key for component '" + parameterization.getModel().getName() + "' since it does not have a parameter with parameter group name " + parameterGroupName + ", named " + parameterName);
        return this.doResolveType(parameterization, new ComponentParameterizationInputMetadataResolutionTypeInformation(parameterization, parameterGroupName, parameterName));
    }

    @Override
    public Optional<MetadataCacheId> getIdForComponentMetadata(ComponentParameterization<?> parameterization) {
        return this.doResolve(parameterization);
    }

    @Override
    public Optional<MetadataCacheId> getIdForMetadataKeys(ComponentParameterization<?> parameterization) {
        return this.doResolveType(parameterization, new KeysMetadataResolutionTypeInformation(parameterization));
    }

    @Override
    public Optional<MetadataCacheId> getIdForGlobalMetadata(ComponentParameterization<?> parameterization) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (parameterization.getModel() instanceof ConfigurationModel) {
            this.resolveComponentIdentifierMetadataCacheId(parameterization).ifPresent(keyParts::add);
            if (parameterization.getModel() instanceof ComponentModel) {
                keyParts.add(this.resolveStereotypeId((ComponentModel)parameterization.getModel()));
            }
            return Optional.of(new MetadataCacheId(keyParts, ComponentParameterizationBasedMetadataCacheIdGenerator.sourceElementName(parameterization)));
        }
        Optional<MetadataCacheId> configId = this.resolveConfigId(parameterization);
        if (configId.isPresent()) {
            keyParts.add(configId.get());
            this.resolveCategoryId(parameterization).ifPresent(keyParts::add);
            return Optional.of(new MetadataCacheId(keyParts, ComponentParameterizationBasedMetadataCacheIdGenerator.sourceElementName(parameterization)));
        }
        if (parameterization.getModel() instanceof ComponentModel) {
            return Optional.of(this.resolveStereotypeId((ComponentModel)parameterization.getModel()));
        }
        return Optional.empty();
    }

    private Optional<MetadataCacheId> doResolve(ComponentParameterization<?> parameterization) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        this.resolveConfigId(parameterization).ifPresent(keyParts::add);
        this.resolveCategoryId(parameterization).ifPresent(keyParts::add);
        this.resolveComponentIdentifierMetadataCacheId(parameterization).ifPresent(keyParts::add);
        if (parameterization.getModel() instanceof ComponentModel) {
            this.resolveMetadataKeyParts(parameterization, (ComponentModel)parameterization.getModel(), true).ifPresent(keyParts::add);
        } else {
            this.resolveNamedConfigId(parameterization).ifPresent(keyParts::add);
        }
        if (keyParts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MetadataCacheId(keyParts, ComponentParameterizationBasedMetadataCacheIdGenerator.sourceElementName(parameterization)));
    }

    private Optional<MetadataCacheId> resolveCategoryId(ComponentParameterization<?> parameterization) {
        if (!(parameterization.getModel() instanceof ComponentModel)) {
            return Optional.empty();
        }
        ComponentModel model = (ComponentModel)parameterization.getModel();
        return model.getModelProperty(MetadataKeyIdModelProperty.class).flatMap(MetadataKeyIdModelProperty::getCategoryName).map(this::createCategoryMetadataCacheId);
    }

    private Optional<MetadataCacheId> doResolveType(ComponentParameterization<?> parameterization, MetadataResolutionTypeInformation typeInformation) {
        ArrayList<MetadataCacheId> keyParts = new ArrayList<MetadataCacheId>();
        if (typeInformation.isDynamicType()) {
            this.resolveComponentExtensionMetadataCacheId(parameterization).ifPresent(keyParts::add);
            this.resolveConfigId(parameterization).ifPresent(keyParts::add);
            typeInformation.getResolverCategory().ifPresent(resolverCategory -> keyParts.add(this.createCategoryMetadataCacheId((String)resolverCategory)));
            typeInformation.getResolverName().ifPresent(resolverName -> keyParts.add(this.createResolverMetadataCacheId((String)resolverName)));
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
            if (parameterization.getModel() instanceof ComponentModel) {
                this.resolveMetadataKeyParts(parameterization, (ComponentModel)parameterization.getModel(), typeInformation.shouldIncludeConfiguredMetadataKeys()).ifPresent(keyParts::add);
            }
        } else {
            this.resolveComponentIdentifierMetadataCacheId(parameterization).ifPresent(keyParts::add);
            if (parameterization.getModel() instanceof ConfigurationModel) {
                this.resolveNamedConfigId(parameterization).ifPresent(keyParts::add);
            }
            keyParts.add(typeInformation.getComponentTypeMetadataCacheId());
        }
        return Optional.of(new MetadataCacheId(keyParts, typeInformation.getComponentTypeMetadataCacheId().getSourceElementName().map(sourceElementName -> String.format("(%s):(%s)", ComponentParameterizationBasedMetadataCacheIdGenerator.sourceElementName(parameterization), sourceElementName)).orElse(String.format("(%s):(%s)", ComponentParameterizationBasedMetadataCacheIdGenerator.sourceElementName(parameterization), "Unknown Type"))));
    }

    private Optional<MetadataCacheId> resolveComponentExtensionMetadataCacheId(ComponentParameterization<?> parameterization) {
        return parameterization.getComponentIdentifier().map(ComponentIdentifier::getNamespace).map(namespace -> new MetadataCacheId(namespace.toLowerCase().hashCode(), (String)namespace));
    }

    private Optional<MetadataCacheId> resolveComponentIdentifierMetadataCacheId(ComponentParameterization<?> parameterization) {
        return parameterization.getComponentIdentifier().map(this::resolveForIdentifier);
    }

    private MetadataCacheId resolveForIdentifier(ComponentIdentifier id) {
        return new MetadataCacheId(id.hashCode(), id.toString());
    }

    private MetadataCacheId resolveStereotypeId(ComponentModel model) {
        StereotypeModel stereotype = model.getStereotype();
        return new MetadataCacheId(stereotype.hashCode(), stereotype.toString());
    }

    private Optional<MetadataCacheId> resolveConfigId(ComponentParameterization<?> parameterization) {
        return ComponentParameterizationBasedMetadataCacheIdGenerator.resolveConfigName(parameterization).flatMap(name -> this.configIdGenerator.getConfigMetadataCacheId((String)name, false));
    }

    private Optional<MetadataCacheId> resolveNamedConfigId(ComponentParameterization<?> parameterization) {
        return ComponentParameterizationBasedMetadataCacheIdGenerator.resolveName(parameterization).flatMap(name -> this.configIdGenerator.getConfigMetadataCacheId((String)name, true));
    }

    private MetadataCacheId createCategoryMetadataCacheId(String category) {
        return new MetadataCacheId(category.hashCode(), "category: " + category);
    }

    private MetadataCacheId createResolverMetadataCacheId(String resolverName) {
        return new MetadataCacheId(resolverName.hashCode(), "resolver: " + resolverName);
    }

    public static String sourceElementName(ComponentParameterization<?> parameterization) {
        return parameterization.getComponentIdentifier().map(id -> id.getNamespace() + ":").orElse("") + parameterization.getModel().getName();
    }

    public static Optional<String> resolveConfigName(ComponentParameterization<?> parameterization) {
        return Optional.ofNullable(parameterization.getParameter("General", CONFIG_ATTRIBUTE_NAME)).map(param -> (String)param);
    }

    public static Optional<String> resolveName(ComponentParameterization<?> parameterization) {
        return Optional.ofNullable(parameterization.getParameter("General", NAME_ATTRIBUTE_NAME)).map(param -> (String)param);
    }

    private Optional<MetadataCacheId> resolveMetadataKeyParts(ComponentParameterization<?> parameterization, ComponentModel componentModel, boolean resolveAllKeys) {
        boolean isPartialFetching = componentModel.getModelProperty(TypeResolversInformationModelProperty.class).map(TypeResolversInformationModelProperty::isPartialTypeKeyResolver).orElse(false);
        if (!isPartialFetching && !resolveAllKeys) {
            return Optional.empty();
        }
        Map<Pair<ParameterGroupModel, ParameterModel>, Object> parameters = parameterization.getParameters();
        List<MetadataCacheId> keyParts = parameters.keySet().stream().filter(pair -> ((ParameterModel)pair.getSecond()).getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(pair -> ((ParameterModel)pair.getSecond()).getModelProperty(MetadataKeyPartModelProperty.class).get().getOrder())).map(p -> this.resolveKeyFromSimpleValue(parameterization, (ParameterGroupModel)p.getFirst(), (ParameterModel)p.getSecond())).collect(Collectors.toList());
        return keyParts.isEmpty() ? Optional.empty() : Optional.of(new MetadataCacheId(keyParts, "metadataKeyValues"));
    }

    private MetadataCacheId resolveKeyFromSimpleValue(ComponentParameterization<?> parameterization, ParameterGroupModel groupModel, ParameterModel param) {
        return (MetadataCacheId)ComponentParameterizationBasedMetadataCacheIdGenerator.computeIdFor(parameterization, groupModel, param, MetadataCacheIdBuilderAdapter::new);
    }

    public static <K> K computeIdFor(ComponentParameterization<?> parameterization, ParameterGroupModel groupModel, ParameterModel parameter, Supplier<CacheIdBuilderAdapter<K>> cacheIdBuilderSupplier) {
        String name = parameter.getName();
        CacheIdBuilderAdapter<K> idBuilder = cacheIdBuilderSupplier.get().withSourceElementName(name).withHashValue(Objects.hashCode(name));
        idBuilder.withHashValue(Objects.hashCode(parameterization.getParameter(groupModel, parameter)));
        return idBuilder.build();
    }
}

