/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthParameterModelProperty;
import org.mule.runtime.extension.api.runtime.parameter.HttpParameterPlacement;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.CustomOAuthParameters;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;

public abstract class BaseOAuthConnectionProviderObjectBuilder<C>
extends DefaultConnectionProviderObjectBuilder<C> {
    public BaseOAuthConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
    }

    public BaseOAuthConnectionProviderObjectBuilder(Class<?> prototypeClass, ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(prototypeClass, providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
    }

    protected Optional<OAuthObjectStoreConfig> buildOAuthObjectStoreConfig(CoreEvent event) throws MuleException {
        ValueResolver<?> resolver = this.resolverSet.getResolvers().get("oauthStoreConfig");
        if (resolver == null) {
            return Optional.empty();
        }
        try (ValueResolvingContext context = this.getResolvingContextFor(event);){
            Map map = (Map)resolver.resolve(context);
            Optional<OAuthObjectStoreConfig> optional = map != null ? Optional.of(new OAuthObjectStoreConfig((String)map.get("objectStore"))) : Optional.empty();
            return optional;
        }
    }

    protected Optional<OAuthObjectStoreConfig> buildOAuthObjectStoreConfig(ResolverSetResult result) {
        Map map = (Map)result.get("oauthStoreConfig");
        return map != null ? Optional.of(new OAuthObjectStoreConfig((String)map.get("objectStore"))) : Optional.empty();
    }

    protected void withCustomParameters(BiConsumer<ParameterModel, OAuthParameterModelProperty> delegate) {
        this.providerModel.getAllParameterModels().forEach(parameter -> parameter.getModelProperty(OAuthParameterModelProperty.class).ifPresent(property -> delegate.accept((ParameterModel)parameter, (OAuthParameterModelProperty)property)));
    }

    protected Object resolve(CoreEvent event, ValueResolver resolver) throws MuleException {
        try (ValueResolvingContext context = this.getResolvingContextFor(event);){
            Object t = resolver.resolve(context);
            return t;
        }
    }

    protected ValueResolvingContext getResolvingContextFor(CoreEvent event) {
        return ValueResolvingContext.builder(event).withExpressionManager(this.expressionManager).build();
    }

    protected MapValueResolver staticOnly(MapValueResolver resolver) throws MuleException {
        ArrayList staticKeyResolvers = new ArrayList(resolver.getKeyResolvers().size());
        ArrayList staticValueResolvers = new ArrayList(resolver.getValueResolvers().size());
        Iterator keyResolvers = resolver.getKeyResolvers().iterator();
        Iterator valueResolvers = resolver.getValueResolvers().iterator();
        while (keyResolvers.hasNext() && valueResolvers.hasNext()) {
            ValueResolver keyResolver = keyResolvers.next();
            ValueResolver valueResolver = valueResolvers.next();
            if (keyResolver.isDynamic() || valueResolver.isDynamic()) continue;
            staticKeyResolvers.add(keyResolver);
            staticValueResolvers.add(valueResolver);
        }
        MapValueResolver result = new MapValueResolver(HashMap.class, staticKeyResolvers, staticValueResolvers, this.getReflectionCache(), this.muleContext);
        LifecycleUtils.initialiseIfNeeded(result, this.muleContext);
        return result;
    }

    protected CustomOAuthParameters getCustomParameters(ResolverSetResult result) {
        return this.getCustomParameters((String key) -> result.get((String)key));
    }

    protected String sanitizePath(String path) {
        return !path.startsWith("/") ? "/" + path : path;
    }

    protected CustomOAuthParameters getCustomParameters(CoreEvent event) {
        return this.getCustomParameters((String key) -> {
            ValueResolver<?> resolver = this.resolverSet.getResolvers().get(key);
            if (resolver != null) {
                return this.resolve(event, resolver);
            }
            return null;
        });
    }

    private CustomOAuthParameters getCustomParameters(Function<String, Object> valueFunction) {
        CustomOAuthParameters params = new CustomOAuthParameters();
        this.withCustomParameters((parameter, property) -> {
            Object value;
            String alias = property.getRequestAlias();
            if (StringUtils.isBlank((CharSequence)alias)) {
                alias = parameter.getName();
            }
            if ((value = valueFunction.apply(parameter.getName())) == null) {
                return;
            }
            MultiMap<String, String> target = switch (property.getPlacement()) {
                case HttpParameterPlacement.QUERY_PARAMS -> params.getQueryParams();
                case HttpParameterPlacement.HEADERS -> params.getHeaders();
                case HttpParameterPlacement.BODY -> params.getBodyParams();
                default -> throw new IllegalArgumentException("Unknown parameter placement: " + property.getPlacement());
            };
            if (value instanceof Map) {
                target.putAll((Map)value);
            } else if (value instanceof List) {
                target.put(alias, (List)value);
            } else {
                target.put(alias, value.toString());
            }
        });
        return params;
    }
}

