/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class SourcePositiveMaxItemsPerPoll
implements Validation {
    @Override
    public String getName() {
        return "Source 'maxItemsPerPoll' is positive";
    }

    @Override
    public String getDescription() {
        return "Source 'maxItemsPerPoll' is positive";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        Predicate<ComponentAst> source = component -> component.getModel(SourceModel.class).isPresent();
        Predicate<ComponentAst> hasParam = component -> {
            ComponentParameterAst parameter = component.getParameter("General", "maxItemsPerPoll");
            return parameter != null && !parameter.getValue().equals(Either.empty());
        };
        return ComponentAstPredicatesFactory.currentElemement(source.and(hasParam));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst parameter = component.getParameter("General", "maxItemsPerPoll");
        int maxItemsPerPoll = (Integer)parameter.getValue().getRight();
        if (maxItemsPerPoll < 1) {
            return Optional.of(ValidationResultItem.create(component, parameter, (Validation)this, String.format("The '%s' parameter must have a value greater than 1", "maxItemsPerPoll")));
        }
        return Optional.empty();
    }
}

