/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.factories;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.function.Supplier;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.internal.util.MultiParentClassLoaderUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationFactory;
import org.mule.runtime.extension.internal.factories.XmlSdkConnectionProviderWrapper;

public class XmlSdkConfigurationFactory
implements ConfigurationFactory {
    private final Supplier<Class<?>> configClass = new LazyValue<Supplier<Class>>(() -> this.createConfigBeanClass(configParamDeclarations));
    private Object lastBuilt;

    public XmlSdkConfigurationFactory(List<ParameterDeclaration> configParamDeclarations) {
    }

    @Override
    public Object newInstance() {
        Object instance;
        try {
            instance = this.configClass.get().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new MuleRuntimeException(e);
        }
        this.lastBuilt = instance;
        return instance;
    }

    @Override
    public Class<?> getObjectType() {
        return this.configClass.get();
    }

    public Object getLastBuilt() {
        Object lastBuilt = this.lastBuilt;
        this.lastBuilt = null;
        return lastBuilt;
    }

    private Class<? extends XmlSdkConnectionProviderWrapper> createConfigBeanClass(List<ParameterDeclaration> paramDeclarations) {
        DynamicType.Builder connectionProviderWrapperClassBuilder = new ByteBuddy().subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.DEFAULT_CONSTRUCTOR);
        for (ParameterDeclaration parameterDeclaration : paramDeclarations) {
            connectionProviderWrapperClassBuilder = connectionProviderWrapperClassBuilder.defineProperty(parameterDeclaration.getName(), String.class);
        }
        return connectionProviderWrapperClassBuilder.make().load(MultiParentClassLoaderUtils.multiParentClassLoaderFor(Thread.currentThread().getContextClassLoader()), (ClassLoadingStrategy)ClassLoadingStrategy.Default.CHILD_FIRST).getLoaded();
    }
}

