/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.metadata.internal.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.util.cache.CacheIdBuilderAdapter;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.RequiredForMetadataModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.metadata.api.cache.MetadataCacheId;
import org.mule.runtime.metadata.internal.cache.MetadataCacheIdBuilderAdapter;

public class ComponentBasedIdHelper {
    private static final String CONFIG_ATTRIBUTE_NAME = "config-ref";

    public static Optional<String> getModelNameAst(ComponentAst component) {
        Optional<NamedObject> namedObjectModel = component.getModel(NamedObject.class);
        if (namedObjectModel.isPresent()) {
            try {
                return namedObjectModel.map(NamedObject::getName);
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
        Optional<Typed> typedObjectModel = component.getModel(Typed.class);
        if (typedObjectModel.isPresent()) {
            return typedObjectModel.map(t -> ExtensionMetadataTypeUtils.getId(t.getType()).toString());
        }
        return Optional.empty();
    }

    public static String sourceElementName(ComponentAst element) {
        return ComponentBasedIdHelper.getModelNameAst(element).map(modelName -> element.getIdentifier().getNamespace() + ":" + modelName + element.getComponentId().map(n -> "[" + n + "]").orElse("")).orElseGet(() -> element.getIdentifier().toString());
    }

    public static String sourceElementNameFromSimpleValue(ComponentAst element) {
        return ComponentBasedIdHelper.getModelNameAst(element).map(modelName -> element.getIdentifier().getNamespace() + ":" + modelName).orElseGet(() -> element.getIdentifier().toString());
    }

    public static Optional<String> resolveConfigName(ComponentAst elementModel) {
        return Optional.ofNullable(elementModel.getParameter("General", CONFIG_ATTRIBUTE_NAME)).map(param -> param.getResolvedRawValue());
    }

    public static List<String> parameterNamesRequiredForMetadataCacheId(ComponentAst component) {
        return component.getModel(EnrichableModel.class).flatMap(model -> model.getModelProperty(RequiredForMetadataModelProperty.class).map(RequiredForMetadataModelProperty::getRequiredParameters)).orElse(Collections.emptyList());
    }

    public static MetadataCacheId resolveComponentIdentifierMetadataCacheId(ComponentAst elementModel) {
        ComponentIdentifier id = elementModel.getIdentifier();
        return new MetadataCacheId(id.hashCode(), id.toString());
    }

    @Deprecated
    public static int computeHashFor(ComponentParameterAst componentParameterAst) {
        return DeprecatedParameterVisitorFunctions.computeHashFor(componentParameterAst);
    }

    public static <K> K computeIdFor(ComponentAst containerComponent, ComponentParameterAst componentParameterAst, Supplier<CacheIdBuilderAdapter<K>> cacheIdBuilderSupplier) {
        return (K)ParameterVisitorFunctions.computeIdFor(containerComponent, componentParameterAst, cacheIdBuilderSupplier);
    }

    public static Optional<MetadataCacheId> resolveMetadataKeyParts(ComponentAst elementModel, ComponentModel componentModel, boolean resolveAllKeys, Function<String, Optional<MetadataCacheId>> calculateForElement) {
        boolean isPartialFetching = componentModel.getModelProperty(TypeResolversInformationModelProperty.class).map(TypeResolversInformationModelProperty::isPartialTypeKeyResolver).orElse(false);
        if (!isPartialFetching && !resolveAllKeys) {
            return Optional.empty();
        }
        List<MetadataCacheId> keyParts = elementModel.getParameters().stream().filter(p -> p.getValue().getValue().isPresent()).filter(p -> p.getModel().getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).sorted(Comparator.comparingInt(p -> p.getModel().getModelProperty(MetadataKeyPartModelProperty.class).get().getOrder())).map(p -> ComponentBasedIdHelper.resolveKeyFromSimpleValue(elementModel, p, calculateForElement)).collect(Collectors.toList());
        return keyParts.isEmpty() ? Optional.empty() : Optional.of(new MetadataCacheId(keyParts, "metadataKeyValues"));
    }

    public static MetadataCacheId resolveKeyFromSimpleValue(ComponentAst elementModel, final ComponentParameterAst param, final Function<String, Optional<MetadataCacheId>> calculateForElement) {
        MetadataCacheId notCheckingReferences = (MetadataCacheId)ComponentBasedIdHelper.computeIdFor(elementModel, param, MetadataCacheIdBuilderAdapter::new);
        return param.getValue().reduce(v -> notCheckingReferences, v -> {
            final Reference reference = new Reference();
            if (v instanceof ComponentAst) {
                param.getModel().getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                        ((Optional)calculateForElement.apply(param.getResolvedRawValue())).ifPresent(reference::set);
                    }

                    @Override
                    public void visitObject(ObjectType objectType) {
                        boolean canBeGlobal = objectType.getAnnotation(TypeDslAnnotation.class).map(TypeDslAnnotation::allowsTopLevelDefinition).orElse(false);
                        if (canBeGlobal) {
                            ((Optional)calculateForElement.apply(param.getResolvedRawValue())).ifPresent(reference::set);
                        }
                    }
                });
            } else {
                final ParameterModel paramModel = param.getModel();
                paramModel.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitString(StringType stringType) {
                        if (!paramModel.getAllowedStereotypes().isEmpty()) {
                            ((Optional)calculateForElement.apply(v.toString())).ifPresent(reference::set);
                        }
                    }

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                        if (paramModel.getDslConfiguration().allowsReferences() && v instanceof String) {
                            ((Optional)calculateForElement.apply(v.toString())).ifPresent(reference::set);
                        }
                    }

                    @Override
                    public void visitObject(ObjectType objectType) {
                        if (paramModel.getDslConfiguration().allowsReferences()) {
                            ((Optional)calculateForElement.apply(v.toString())).ifPresent(reference::set);
                        }
                    }
                });
            }
            return reference.get() == null ? notCheckingReferences : (MetadataCacheId)reference.get();
        });
    }

    @Deprecated
    private static class DeprecatedParameterVisitorFunctions {
        private StringBuilder hashBuilder = new StringBuilder();
        private final Function<String, Void> leftFunction = this::hashForLeft;
        private final Function<Object, Void> rightFunction = this::hashForRight;

        private static int computeHashFor(ComponentParameterAst parameter) {
            return Objects.hashCode(new DeprecatedParameterVisitorFunctions((ComponentParameterAst)parameter).hashBuilder.toString());
        }

        private DeprecatedParameterVisitorFunctions(ComponentParameterAst startingParameter) {
            startingParameter.getValue().reduce(this.leftFunction, this.rightFunction);
        }

        private Void hashForLeft(String s) {
            this.hashBuilder.append(s);
            return null;
        }

        private Void hashForRight(Object o) {
            if (o instanceof ComponentAst) {
                ComponentAst c = (ComponentAst)o;
                c.getParameters().stream().filter(componentParameterAst -> componentParameterAst.getValue().getValue().isPresent()).sorted(Comparator.comparing(p -> p.getModel().getName())).forEach(p -> {
                    this.hashBuilder.append(p.getModel().getName());
                    if (p.getModel().getType() instanceof ArrayType) {
                        this.hashForList((Collection)p.getValue().getRight());
                    } else {
                        p.getValue().reduce(this.leftFunction, this.rightFunction);
                    }
                });
            } else {
                this.hashBuilder.append(o);
            }
            return null;
        }

        private void hashForList(Collection<ComponentAst> collection) {
            collection.forEach(c -> {
                ComponentParameterAst parameterAst = c.getParameter("General", "value");
                if (parameterAst == null) {
                    this.rightFunction.apply(c);
                } else {
                    parameterAst.getValue().reduce(this.leftFunction, this.rightFunction);
                }
            });
        }
    }

    private static class ParameterVisitorFunctions<K> {
        private final Supplier<CacheIdBuilderAdapter<K>> idBuilderSupplier;
        private final CacheIdBuilderAdapter<K> idBuilder;

        private static <T> T computeIdFor(ComponentAst containerComponent, ComponentParameterAst parameter, Supplier<CacheIdBuilderAdapter<T>> cacheIdBuilderSupplier) {
            return (T)new ParameterVisitorFunctions<K>((ComponentAst)containerComponent, (ComponentParameterAst)parameter, cacheIdBuilderSupplier).idBuilder.build();
        }

        private static <T> T computeIdFor(ComponentAst componentAst, Supplier<CacheIdBuilderAdapter<T>> cacheIdBuilderSupplier) {
            return (T)new ParameterVisitorFunctions<K>((ComponentAst)componentAst, cacheIdBuilderSupplier).idBuilder.build();
        }

        private ParameterVisitorFunctions(ComponentAst containerComponent, ComponentParameterAst parameterAst, Supplier<CacheIdBuilderAdapter<K>> cacheKeyBuilderSupplier) {
            String name = parameterAst.getGenerationInformation().getSyntax().map(s -> {
                if (StringUtils.isEmpty(s.getElementName())) {
                    return s.getAttributeName();
                }
                return s.getPrefix() + ":" + s.getElementName();
            }).orElse(containerComponent.getIdentifier().getNamespace() + ":" + parameterAst.getModel().getName());
            this.idBuilderSupplier = cacheKeyBuilderSupplier;
            this.idBuilder = this.idBuilderSupplier.get().withSourceElementName(name).withHashValue(Objects.hashCode(name));
            parameterAst.getValue().reduce(v -> this.hashForLeft(parameterAst.getRawValue()), this::hashForRight);
        }

        private ParameterVisitorFunctions(ComponentAst component, Supplier<CacheIdBuilderAdapter<K>> cacheKeyBuilderSupplier) {
            String name = component.getIdentifier().toString();
            this.idBuilderSupplier = cacheKeyBuilderSupplier;
            this.idBuilder = this.idBuilderSupplier.get().withSourceElementName(name).withHashValue(Objects.hashCode(name));
            this.idBuilder.containing(component.getParameters().stream().filter(componentParameterAst -> componentParameterAst.getValue().getValue().isPresent()).map(p -> ParameterVisitorFunctions.computeIdFor(component, p, cacheKeyBuilderSupplier)).collect(Collectors.toList()));
        }

        private Void hashForLeft(String s) {
            this.idBuilder.withHashValue(Objects.hashCode(s));
            return null;
        }

        private Void hashForRight(Object o) {
            if (o instanceof Collection) {
                Collection collection = (Collection)o;
                this.idBuilder.containing(collection.stream().map(e -> ParameterVisitorFunctions.computeIdFor(e, this.idBuilderSupplier)).collect(Collectors.toList()));
            } else if (o instanceof ComponentAst) {
                ComponentAst c = (ComponentAst)o;
                this.idBuilder.containing(c.getParameters().stream().filter(componentParameterAst -> componentParameterAst.getValue().getValue().isPresent()).sorted(Comparator.comparing(p -> p.getModel().getName())).map(p -> ParameterVisitorFunctions.computeIdFor(c, p, this.idBuilderSupplier)).collect(Collectors.toList()));
            } else if (o != null) {
                this.idBuilder.withHashValue(Objects.hashCode(o.toString()));
            }
            return null;
        }
    }
}

