/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.internal.descriptor;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.manifest.api.MuleManifest;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidator;

public class MinMuleVersionArtifactDescriptorValidator
implements ArtifactDescriptorValidator {
    private boolean validateMinMuleVersionWithSemanticVersion;
    private Supplier<String> muleRuntimeVersionSupplier = () -> MuleManifest.getMuleManifest().getProductVersion();

    public MinMuleVersionArtifactDescriptorValidator(boolean validateMinMuleVersionWithSemanticVersion) {
        this.validateMinMuleVersionWithSemanticVersion = validateMinMuleVersionWithSemanticVersion;
    }

    public MinMuleVersionArtifactDescriptorValidator(boolean validateMinMuleVersionWithSemanticVersion, Supplier<String> muleRuntimeVersionSupplier) {
        this(validateMinMuleVersionWithSemanticVersion);
        Objects.requireNonNull(muleRuntimeVersionSupplier, "muleRuntimeVersionSupplier cannot be null");
        this.muleRuntimeVersionSupplier = muleRuntimeVersionSupplier;
    }

    @Override
    public void validate(ArtifactDescriptor descriptor) {
        MuleVersion minMuleVersion = descriptor.getMinMuleVersion();
        MuleVersion runtimeVersion = new MuleVersion(this.muleRuntimeVersionSupplier.get());
        runtimeVersion = new MuleVersion(runtimeVersion.toCompleteNumericVersion().replace("-" + runtimeVersion.getSuffix(), ""));
        if (this.validateMinMuleVersionWithSemanticVersion) {
            minMuleVersion = this.toBaseVersion(minMuleVersion);
            runtimeVersion = this.toBaseVersion(runtimeVersion);
        }
        this.doValidation(descriptor, minMuleVersion, runtimeVersion);
    }

    private MuleVersion toBaseVersion(MuleVersion version) {
        return new MuleVersion(version.getMajor() + "." + version.getMinor());
    }

    private void doValidation(ArtifactDescriptor descriptor, MuleVersion minMuleVersion, MuleVersion runtimeVersion) {
        if (runtimeVersion.priorTo(minMuleVersion)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Artifact %s requires a newest runtime version. Artifact required version is %s and Mule Runtime version is %s", descriptor.getName(), descriptor.getMinMuleVersion().toCompleteNumericVersion(), runtimeVersion.toCompleteNumericVersion()));
        }
    }
}

