/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction.xa;

import javax.transaction.TransactionManager;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.transaction.XaTransaction;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.transaction.TransactionFactory;

@NoExtend
public class XaTransactionFactory
implements TransactionFactory {
    private int timeout;

    @Override
    public Transaction beginTransaction(String applicationName, NotificationDispatcher notificationFirer, TransactionManager transactionManager) throws TransactionException {
        try {
            XaTransaction xat = new XaTransaction(applicationName, transactionManager, notificationFirer);
            xat.setTimeout(this.timeout);
            xat.begin();
            return xat;
        }
        catch (Exception e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    public Transaction beginTransaction(MuleContext muleContext) throws TransactionException {
        try {
            return this.beginTransaction(muleContext.getConfiguration().getId(), ((MuleContextWithRegistry)muleContext).getRegistry().lookupObject(NotificationDispatcher.class), muleContext.getTransactionManager());
        }
        catch (RegistrationException e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction("XA"), (Throwable)e);
        }
    }

    @Override
    public boolean isTransacted() {
        return true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

