/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.connection;

import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.registry.InjectionTargetDecorator;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.SdkConnectionValidationResultAdapter;
import org.mule.sdk.api.connectivity.CachedConnectionProvider;
import org.mule.sdk.api.connectivity.PoolingConnectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkConnectionProviderAdapter<C>
implements ConnectionProvider<C>,
Lifecycle,
MuleContextAware,
InjectionTargetDecorator<org.mule.sdk.api.connectivity.ConnectionProvider<C>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SdkConnectionProviderAdapter.class);
    private final org.mule.sdk.api.connectivity.ConnectionProvider<C> delegate;
    @Inject
    private MuleContext muleContext;

    public static <C> ConnectionProvider<C> from(Object connectionProvider) {
        if (connectionProvider != null) {
            if (connectionProvider instanceof ConnectionProvider) {
                return (ConnectionProvider)connectionProvider;
            }
            if (connectionProvider instanceof CachedConnectionProvider) {
                return new SdkCachedConnectionProviderAdapter((CachedConnectionProvider)connectionProvider);
            }
            if (connectionProvider instanceof PoolingConnectionProvider) {
                return new SdkPoolingConnectionProviderAdapter((PoolingConnectionProvider)connectionProvider);
            }
            if (connectionProvider instanceof org.mule.sdk.api.connectivity.ConnectionProvider) {
                return new SdkConnectionProviderAdapter<C>((org.mule.sdk.api.connectivity.ConnectionProvider)connectionProvider);
            }
            throw new IllegalArgumentException("Unsupported ConnectionProvider type " + connectionProvider.getClass().getName());
        }
        throw new IllegalArgumentException("connectionProvider cannot be null");
    }

    private SdkConnectionProviderAdapter(org.mule.sdk.api.connectivity.ConnectionProvider<C> delegate) {
        this.delegate = delegate;
    }

    @Override
    public C connect() throws ConnectionException {
        return this.delegate.connect();
    }

    @Override
    public void disconnect(C connection) {
        this.delegate.disconnect(connection);
    }

    @Override
    public ConnectionValidationResult validate(C connection) {
        return new SdkConnectionValidationResultAdapter(this.delegate.validate(connection));
    }

    @Override
    public org.mule.sdk.api.connectivity.ConnectionProvider<C> getDelegate() {
        return this.delegate;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.muleContext != null) {
            LifecycleUtils.initialiseIfNeeded(this.delegate, true, this.muleContext);
        } else {
            LifecycleUtils.initialiseIfNeeded(this.delegate);
        }
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.delegate);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.delegate);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.delegate instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.delegate)).setMuleContext(this.muleContext);
        }
    }

    private static class SdkCachedConnectionProviderAdapter<C>
    extends SdkConnectionProviderAdapter<C>
    implements org.mule.runtime.api.connection.CachedConnectionProvider<C> {
        private SdkCachedConnectionProviderAdapter(CachedConnectionProvider<C> delegate) {
            super(delegate);
        }
    }

    private static class SdkPoolingConnectionProviderAdapter<C>
    extends SdkConnectionProviderAdapter<C>
    implements org.mule.runtime.api.connection.PoolingConnectionProvider<C> {
        private final PoolingConnectionProvider<C> delegate;

        private SdkPoolingConnectionProviderAdapter(PoolingConnectionProvider<C> delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void onBorrow(C connection) {
            this.delegate.onBorrow(connection);
        }

        @Override
        public void onReturn(C connection) {
            this.delegate.onReturn(connection);
        }
    }
}

