/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.singleapp;

import java.io.FileWriter;
import java.io.IOException;
import java.util.function.Consumer;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteToRouteTerminationHandler
implements Consumer<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteToRouteTerminationHandler.class);
    public static final String MULE_TERMINATION_LOG_PATH_ENV_VARIABLE = "MULE_TERMINATION_LOG_PATH";
    private final Consumer<Throwable> shutdownConsumer;

    public WriteToRouteTerminationHandler(Consumer<Throwable> shutdownConsumer) {
        this.shutdownConsumer = shutdownConsumer;
    }

    @Override
    public void accept(Throwable terminationThrowable) {
        String muleTerminationLogRoute = WriteToRouteTerminationHandler.resolveTerminationPath();
        if (muleTerminationLogRoute != null) {
            try (FileWriter errorWriter = new FileWriter(muleTerminationLogRoute);){
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)terminationThrowable);
                if (rootCause != null) {
                    errorWriter.write(rootCause.getMessage());
                } else {
                    errorWriter.write("Unable to write the root cause of ");
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error on writing termination cause to termination route");
            }
        }
        this.shutdownConsumer.accept(terminationThrowable);
    }

    private static String resolveTerminationPath() {
        String terminationPath = System.getProperty("mule.termination.log.path");
        if (terminationPath == null) {
            terminationPath = System.getenv(MULE_TERMINATION_LOG_PATH_ENV_VARIABLE);
        }
        return terminationPath;
    }
}

