/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;

public class SerializationContext {
    private final Map<String, ObjectType> objectTypes = new LinkedHashMap<String, ObjectType>();

    public String registerObjectType(ObjectType objectType) {
        String typeId = MetadataTypeUtils.getTypeId(objectType).orElseThrow(() -> new IllegalArgumentException("Cannot doSerialize an object type without type id"));
        this.objectTypes.put(typeId, objectType);
        return typeId;
    }

    public Optional<ObjectType> getRegisteredObjectType(String registrationId) {
        return Optional.ofNullable(this.objectTypes.get(registrationId));
    }

    public List<ObjectType> getRegisteredObjectTypes() {
        return Collections.unmodifiableList(new ArrayList<ObjectType>(this.objectTypes.values()));
    }
}

