/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.serialization.impl.gson.adapter;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.serialization.impl.gson.adapter.ElementDeclarationSerializationUtils;

class ConnectionElementDeclarationTypeAdapter
extends TypeAdapter<ConnectionElementDeclaration> {
    private final Gson delegate;

    public ConnectionElementDeclarationTypeAdapter(Gson delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, ConnectionElementDeclaration value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginObject();
        ElementDeclarationSerializationUtils.populateParameterizedObject(this.delegate, out, value, "CONNECTION");
        out.endObject();
    }

    public ConnectionElementDeclaration read(JsonReader in) throws IOException {
        JsonObject jsonObject;
        JsonElement elementKind;
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        JsonElement parse = new JsonParser().parse(in);
        if (parse.isJsonObject() && (elementKind = (jsonObject = parse.getAsJsonObject()).get("kind")) != null && elementKind.getAsString().equals("CONNECTION")) {
            String name = jsonObject.get("name").getAsString();
            String declaringExtension = jsonObject.get("declaringExtension").getAsString();
            ConnectionElementDeclarer declarer = ElementDeclarer.forExtension(declaringExtension).newConnection(name);
            ElementDeclarationSerializationUtils.declareParameterizedElement(this.delegate, jsonObject, declarer);
            return (ConnectionElementDeclaration)declarer.getDeclaration();
        }
        return null;
    }
}

