/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.core.privileged.extension.SingletonModelProperty;

public class SingletonsAreNotRepeated
implements Validation {
    @Override
    public String getName() {
        return "Singletons are not repeated";
    }

    @Override
    public String getDescription() {
        return "Elements declared as singletons via the 'SingletonModelProperty' are not repeated.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(EnrichableModel.class).flatMap(enrchModel -> enrchModel.getModelProperty(SingletonModelProperty.class).map(smp -> this.isApplicable((SingletonModelProperty)smp))).orElse(false)));
    }

    protected boolean isApplicable(SingletonModelProperty smp) {
        return !smp.isAppliesToFile();
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        List repeated = artifact.topLevelComponentsStream().filter(comp -> !comp.equals(component)).filter(this.additionalFilter(component)).filter(ComponentAstPredicatesFactory.equalsIdentifier(component.getIdentifier())).collect(Collectors.toList());
        if (repeated.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<ComponentAst> allRepeated = new ArrayList<ComponentAst>();
        allRepeated.add(component);
        allRepeated.addAll(repeated);
        return Optional.of(ValidationResultItem.create(allRepeated, (Validation)this, "The configuration element '" + String.valueOf(component.getIdentifier()) + "' can only appear once."));
    }

    protected Predicate<? super ComponentAst> additionalFilter(ComponentAst component) {
        return comp -> true;
    }
}

