/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.tooling;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginDependenciesResolver;
import org.mule.runtime.deployment.model.api.plugin.resolver.PluginResolutionError;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.deployment.model.internal.tooling.ToolingRegionClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;

public class ToolingPluginClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<ToolingPluginClassLoaderBuilder> {
    private static final String TOOLING_EXTENSION_MODEL = "tooling-extension-model";
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private final ArtifactPluginDescriptor artifactPluginDescriptor;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private ArtifactClassLoader parentClassLoader;

    public ToolingPluginClassLoaderBuilder(DeployableArtifactClassLoaderFactory artifactClassLoaderFactory, PluginDependenciesResolver pluginDependenciesResolver, ArtifactPluginDescriptor artifactPluginDescriptor, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactPluginDescriptor = artifactPluginDescriptor;
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor);
    }

    public ToolingPluginClassLoaderBuilder setParentClassLoader(ArtifactClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return TOOLING_EXTENSION_MODEL + UUID.getUUID() + "/" + artifactDescriptor.getName();
    }

    @Override
    public ToolingArtifactClassLoader build() {
        this.setArtifactDescriptor(new ArtifactDescriptor(TOOLING_EXTENSION_MODEL));
        List<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(Collections.emptySet(), (List<ArtifactPluginDescriptor>)ImmutableList.builder().add((Object)this.artifactPluginDescriptor).build(), true);
        this.addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[resolvedArtifactPluginDescriptors.size()]));
        ArtifactClassLoader ownerArtifactClassLoader = super.build();
        ClassLoader parent = ownerArtifactClassLoader.getClassLoader().getParent();
        if (!(parent instanceof RegionClassLoader)) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("The parent of the current owner must be of type '%s' but found '%s'", RegionClassLoader.class.getName(), parent.getClass().getName())));
        }
        RegionClassLoader regionClassLoader = (RegionClassLoader)parent;
        return new ToolingArtifactClassLoader(regionClassLoader, ToolingPluginClassLoaderBuilder.getPluginArtifactClassLoader(this.artifactPluginDescriptor, regionClassLoader.getArtifactPluginClassLoaders()));
    }

    @Override
    protected RegionClassLoader createRegionClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, ClassLoader parentClassLoader, ClassLoaderLookupPolicy parentLookupPolicy) {
        return ToolingRegionClassLoader.newToolingRegionClassLoader(artifactId, artifactDescriptor, parentClassLoader, parentLookupPolicy);
    }

    protected static ArtifactClassLoader getPluginArtifactClassLoader(ArtifactPluginDescriptor artifactPluginDescriptor, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        return artifactPluginClassLoaders.stream().filter(artifactClassLoader -> artifactClassLoader.getArtifactId().endsWith("/plugin/" + artifactPluginDescriptor.getName())).findFirst().orElseThrow(() -> new PluginResolutionError(String.format("Cannot generate a tooling ClassLoader as the region ClassLoader is missing the plugin '%s'", artifactPluginDescriptor.getName())));
    }
}

