/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.config.factory;

import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.dsl.api.component.ObjectFactory;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.MuleOperation;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.Operation;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.mule.internal.config.provider.OperationDslBuildingDefinitionProvider;

public class DefaultOperationObjectFactory
extends AbstractComponent
implements ObjectFactory<Operation> {
    private final String name;
    private final ExtensionManager extensionManager;
    private final MuleContext muleContext;
    private OperationDslBuildingDefinitionProvider.OperationBody body;

    public DefaultOperationObjectFactory(String name, ExtensionManager extensionManager, MuleContext muleContext) {
        this.name = name;
        this.extensionManager = extensionManager;
        this.muleContext = muleContext;
    }

    @Override
    public Operation getObject() {
        Operation operation = MuleOperation.builder().processors(this.body.getProcessors()).setOperationModel(this.locateOperationModel()).setMuleContext(this.muleContext).build();
        operation.setAnnotations(this.getAnnotations());
        return operation;
    }

    private OperationModel locateOperationModel() {
        ExtensionModel extensionModel = this.extensionManager.getExtension(this.muleContext.getConfiguration().getId()).orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Cannot parse operation '%s'. Application ExtensionModel not found", this.name)));
        return MuleExtensionUtils.findOperation(extensionModel, this.name).orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Cannot parse operation '%s'. OperationModel not found", this.name)));
    }

    public void setBody(OperationDslBuildingDefinitionProvider.OperationBody body) {
        this.body = body;
    }
}

