/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.privileged.error;

import java.util.Objects;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.message.ErrorType;

@NoInstantiate
public final class DefaultErrorType
implements ErrorType {
    private static final long serialVersionUID = -3716206147606234572L;
    private final String identifier;
    private final String namespace;
    private final ErrorType parentErrorType;
    private final String asString;

    public DefaultErrorType(String identifier, String namespace, ErrorType parentErrorType) {
        this.identifier = identifier;
        this.namespace = namespace;
        this.parentErrorType = parentErrorType;
        this.asString = String.format("%s:%s", namespace, identifier);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public ErrorType getParentErrorType() {
        return this.parentErrorType;
    }

    public String toString() {
        return this.asString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultErrorType that = (DefaultErrorType)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.parentErrorType, that.parentErrorType);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.namespace, this.parentErrorType);
    }
}

