/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ObjectBuilderUtils;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;

public class DefaultResolverSetBasedObjectBuilder<T>
extends ResolverSetBasedObjectBuilder<T> {
    private final Class<T> prototypeClass;
    private final ClassLoader prototypeClassClassLoader;

    public DefaultResolverSetBasedObjectBuilder(Class<T> prototypeClass, ResolverSet resolverSet, ExpressionManager expressionManager, MuleContext context) {
        super(prototypeClass, resolverSet, expressionManager, context);
        this.prototypeClass = prototypeClass;
        this.prototypeClassClassLoader = prototypeClass.getClassLoader();
    }

    @Override
    protected T instantiateObject() {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.prototypeClassClassLoader);
        try {
            T t = ObjectBuilderUtils.createInstance(this.prototypeClass);
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of " + String.valueOf(this.prototypeClass)), (Throwable)e);
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.prototypeClassClassLoader, currentClassLoader);
        }
    }
}

