/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;

public class DefaultConfigurationParameters
implements ConfigurationParameters {
    private final Map<String, Object> simpleConfigurationParameters;
    private final MultiMap<ComponentIdentifier, ConfigurationParameters> complexConfigurationParameters;

    private DefaultConfigurationParameters(Map<String, Object> simpleConfigurationParameters, MultiMap<ComponentIdentifier, ConfigurationParameters> complexConfigurationParameters) {
        this.simpleConfigurationParameters = simpleConfigurationParameters;
        this.complexConfigurationParameters = complexConfigurationParameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getStringParameter(String parameterName) {
        Object parameter = this.simpleConfigurationParameters.get(parameterName);
        return parameter != null ? parameter.toString() : null;
    }

    @Override
    public List<ConfigurationParameters> getComplexConfigurationParameter(ComponentIdentifier componentIdentifier) {
        return this.complexConfigurationParameters.getAll(componentIdentifier);
    }

    @Override
    public List<Pair<ComponentIdentifier, ConfigurationParameters>> getComplexConfigurationParameters() {
        return this.complexConfigurationParameters.entryList().stream().map(entry -> new Pair<ComponentIdentifier, ConfigurationParameters>((ComponentIdentifier)entry.getKey(), (ConfigurationParameters)entry.getValue())).collect(Collectors.toList());
    }

    public static class Builder {
        private final Map<String, Object> simpleConfigurationParameters = new HashMap<String, Object>();
        private final MultiMap<ComponentIdentifier, ConfigurationParameters> complexConfigurationParameters = new MultiMap();

        private Builder() {
        }

        public Builder withSimpleParameter(String parameterName, Object parameterValue) {
            this.simpleConfigurationParameters.put(parameterName, parameterValue);
            return this;
        }

        public Builder withComplexParameter(ComponentIdentifier componentIdentifier, ConfigurationParameters configurationParameters) {
            this.complexConfigurationParameters.put(componentIdentifier, configurationParameters);
            return this;
        }

        public ConfigurationParameters build() {
            return new DefaultConfigurationParameters(this.simpleConfigurationParameters, this.complexConfigurationParameters);
        }
    }
}

