/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public final class SubtypesModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        Map<ObjectType, Set<ObjectType>> typesMapping = ExtensionModelUtils.toSubTypesMap(model.getSubTypes());
        this.validateBaseTypeNotFinal(model, typesMapping, problemsReporter);
        this.validateSubtypesExtendOrImplementBaseType(model, typesMapping, problemsReporter);
    }

    private void validateBaseTypeNotFinal(ExtensionModel model, Map<ObjectType, Set<ObjectType>> typesMapping, ProblemsReporter problemsReporter) {
        List finalBaseTypes = typesMapping.keySet().stream().filter(ExtensionMetadataTypeUtils::isFinal).map(type -> ExtensionMetadataTypeUtils.getId(type).orElse(null)).filter(type -> type != null).collect(Collectors.toList());
        if (!finalBaseTypes.isEmpty()) {
            problemsReporter.addError(new Problem(model, String.format("All the declared SubtypesMapping should have non final base types, but [%s] are final", Arrays.toString(finalBaseTypes.toArray()))));
        }
    }

    private void validateSubtypesExtendOrImplementBaseType(ExtensionModel model, Map<ObjectType, Set<ObjectType>> typesMapping, ProblemsReporter problemsReporter) {
        for (Map.Entry<ObjectType, Set<ObjectType>> subtypes : typesMapping.entrySet()) {
            List invalidTypes;
            Optional baseType = ExtensionMetadataTypeUtils.getType(subtypes.getKey());
            if (!baseType.isPresent() || (invalidTypes = subtypes.getValue().stream().map(ExtensionMetadataTypeUtils::getType).filter(Optional::isPresent).map(Optional::get).filter(s -> !((Class)baseType.get()).isAssignableFrom((Class<?>)s)).map(Class::getSimpleName).collect(Collectors.toList())).isEmpty()) continue;
            problemsReporter.addError(new Problem(model, String.format("All the declared Subtypes should be concrete implementations of the give baseType, but [%s] are not implementations of [%s]", Arrays.toString(invalidTypes.toArray()), baseType.get().getSimpleName())));
        }
    }
}

