/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.validation.Severity;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractExpressionSyntacticallyValid;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class ExpressionParametersSyntacticallyValid
extends AbstractExpressionSyntacticallyValid {
    public ExpressionParametersSyntacticallyValid(ExpressionLanguage expressionLanguage, Supplier<Validation.Level> level, Severity severity) {
        super(expressionLanguage, level, severity);
    }

    @Override
    public String getName() {
        return "Expression are syntactically valid";
    }

    @Override
    public String getDescription() {
        return "Expression are syntactically valid";
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(c -> c.getModel(ParameterizedModel.class).map(pmzd -> pmzd.getParameterGroupModels().stream().anyMatch(pmg -> pmg.getParameterModels().stream().anyMatch(pm -> {
            ComponentParameterAst param = c.getParameter(pmg.getName(), pm.getName());
            return param != null && param.getValue().isLeft();
        }))).orElse(false));
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmz -> ExtensionModelUtils.getGroupAndParametersPairs(pmz).map(gnp -> component.getParameter(((ParameterGroupModel)gnp.getFirst()).getName(), ((ParameterModel)gnp.getSecond()).getName())).filter(param -> param != null && param.getValue().isLeft()).flatMap(param -> this.validateExpression(component, (ComponentParameterAst)param, param.getValue().getLeft())).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

