/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.descriptor;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;

@NoExtend
public class ClassLoaderConfiguration {
    public static final ClassLoaderConfiguration NULL_CLASSLOADER_CONFIGURATION = new ClassLoaderConfiguration(new URL[0], Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), false);
    private final URL[] urls;
    private final Set<String> exportedPackages;
    private final Set<String> exportedResources;
    private final Set<String> localPackages;
    private final Set<String> localResources;
    private final Set<BundleDependency> dependencies;
    private final Set<String> privilegedExportedPackages;
    private final Set<String> privilegedArtifacts;
    private final boolean includeTestDependencies;

    protected ClassLoaderConfiguration(URL[] urls, Set<String> exportedPackages, Set<String> exportedResources, Set<String> localPackages, Set<String> localResources, Set<BundleDependency> dependencies, Set<String> privilegedExportedPackages, Set<String> privilegedArtifacts, boolean includeTestDependencies) {
        this.urls = urls;
        this.exportedPackages = exportedPackages;
        this.exportedResources = exportedResources;
        this.localPackages = localPackages;
        this.localResources = localResources;
        this.dependencies = dependencies;
        this.privilegedExportedPackages = privilegedExportedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
        this.includeTestDependencies = includeTestDependencies;
    }

    public URL[] getUrls() {
        return this.urls;
    }

    public Set<String> getExportedPackages() {
        return this.exportedPackages;
    }

    public Set<String> getExportedResources() {
        return this.exportedResources;
    }

    public Set<String> getLocalPackages() {
        return this.localPackages;
    }

    public Set<String> getLocalResources() {
        return this.localResources;
    }

    public Set<BundleDependency> getDependencies() {
        return this.dependencies;
    }

    public Set<String> getPrivilegedExportedPackages() {
        return this.privilegedExportedPackages;
    }

    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }

    public boolean isIncludeTestDependencies() {
        return this.includeTestDependencies;
    }

    public static class ClassLoaderConfigurationBuilder {
        private final Set<String> packages = new HashSet<String>();
        private final Set<String> resources = new HashSet<String>();
        private final Set<String> localPackages = new HashSet<String>();
        private final Set<String> localResources = new HashSet<String>();
        private List<URL> urls = new ArrayList<URL>();
        protected Set<BundleDependency> dependencies = new HashSet<BundleDependency>();
        private final Set<String> privilegedExportedPackages = new HashSet<String>();
        private final Set<String> privilegedArtifacts = new HashSet<String>();
        private Boolean includeTestDependencies = Boolean.FALSE;

        public ClassLoaderConfigurationBuilder() {
        }

        public ClassLoaderConfigurationBuilder(ClassLoaderConfiguration source) {
            Preconditions.checkArgument(source != null, "source cannot be null");
            this.packages.addAll(source.exportedPackages);
            this.resources.addAll(source.exportedResources);
            this.localPackages.addAll(source.localPackages);
            this.localResources.addAll(source.localResources);
            this.urls = new ArrayList<URL>(Arrays.asList(source.urls));
            this.dependencies.addAll(source.dependencies);
            this.privilegedExportedPackages.addAll(source.privilegedExportedPackages);
            this.privilegedArtifacts.addAll(source.privilegedArtifacts);
        }

        public ClassLoaderConfigurationBuilder exportingPackages(Set<String> packages) {
            Preconditions.checkArgument(packages != null, "packages cannot be null");
            this.packages.addAll(packages);
            return this;
        }

        public ClassLoaderConfigurationBuilder exportingResources(Set<String> resources) {
            Preconditions.checkArgument(resources != null, "resources cannot be null");
            resources.stream().forEach(r -> this.resources.add(FilenameUtils.separatorsToUnix((String)r)));
            return this;
        }

        public ClassLoaderConfigurationBuilder withLocalPackages(Set<String> packages) {
            Preconditions.checkArgument(packages != null, "packages cannot be null");
            this.localPackages.addAll(packages);
            return this;
        }

        public ClassLoaderConfigurationBuilder withLocalResources(Set<String> resources) {
            Preconditions.checkArgument(resources != null, "resources cannot be null");
            resources.stream().forEach(r -> this.localResources.add(FilenameUtils.separatorsToUnix((String)r)));
            return this;
        }

        public ClassLoaderConfigurationBuilder exportingPrivilegedPackages(Set<String> packages, Set<String> artifactIds) {
            Preconditions.checkArgument(packages != null, "packages cannot be null");
            Preconditions.checkArgument(artifactIds != null, "artifactIds cannot be null");
            Preconditions.checkArgument(packages.isEmpty() == artifactIds.isEmpty(), "Both packages and artifactIds must be empty or non empty simultaneously");
            this.privilegedExportedPackages.addAll(packages);
            this.privilegedArtifacts.addAll(artifactIds);
            return this;
        }

        public ClassLoaderConfigurationBuilder dependingOn(Set<BundleDependency> dependencies) {
            Preconditions.checkArgument(dependencies != null, "dependencies cannot be null");
            this.dependencies.addAll(dependencies);
            return this;
        }

        public ClassLoaderConfigurationBuilder containing(URL url) {
            Preconditions.checkArgument(url != null, "url cannot be null");
            this.urls.add(url);
            return this;
        }

        public ClassLoaderConfigurationBuilder containing(List<URL> urls) {
            Preconditions.checkArgument(urls != null, "urls cannot be null");
            this.urls.addAll(urls);
            return this;
        }

        public ClassLoaderConfigurationBuilder includeTestDependencies(boolean includeTestDependencies) {
            this.includeTestDependencies = includeTestDependencies;
            return this;
        }

        private void filterExportedFromLocalResources() {
            this.localPackages.removeAll(this.packages);
            this.localResources.removeAll(this.resources);
        }

        protected Set<String> getPackages() {
            return this.packages;
        }

        protected Set<String> getResources() {
            return this.resources;
        }

        protected Set<String> getLocalPackages() {
            return this.localPackages;
        }

        protected Set<String> getLocalResources() {
            return this.localResources;
        }

        protected List<URL> getUrls() {
            return this.urls;
        }

        protected Set<String> getPrivilegedExportedPackages() {
            return this.privilegedExportedPackages;
        }

        protected Set<String> getPrivilegedArtifacts() {
            return this.privilegedArtifacts;
        }

        protected Boolean getIncludeTestDependencies() {
            return this.includeTestDependencies;
        }

        public ClassLoaderConfiguration build() {
            this.filterExportedFromLocalResources();
            return this.doBuild();
        }

        protected ClassLoaderConfiguration doBuild() {
            return new ClassLoaderConfiguration(this.urls.toArray(new URL[0]), Collections.unmodifiableSet(this.packages), Collections.unmodifiableSet(this.resources), Collections.unmodifiableSet(this.localPackages), Collections.unmodifiableSet(this.localResources), Collections.unmodifiableSet(this.dependencies), Collections.unmodifiableSet(this.privilegedExportedPackages), Collections.unmodifiableSet(this.privilegedArtifacts), this.includeTestDependencies);
        }
    }
}

