/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.internal;

import java.io.File;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.raml.internal.TypeDeclarationTypeLoader;
import org.mule.metadata.raml.internal.fragments.AbstractTypeDeclarationLoader;
import org.mule.metadata.raml.internal.fragments.DataTypeTypeDeclarationLoader;
import org.mule.metadata.raml.internal.fragments.LibraryTypeDeclarationLoader;
import org.mule.metadata.raml.internal.util.RamlLoaderUtils;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RamlTypeLoader
implements TypeLoader {
    private final AbstractTypeDeclarationLoader fragmentTypeLoader;
    private final TypeDeclarationTypeLoader typeDeclarationTypeLoader;

    public RamlTypeLoader(File ramlFile, TypeDeclarationTypeLoader typeDeclarationTypeLoader) {
        RamlModelResult ramlModelResult = RamlLoaderUtils.buildApiOrFail(ramlFile);
        this.fragmentTypeLoader = this.createDelegate(ramlModelResult, ramlFile.getPath());
        this.typeDeclarationTypeLoader = typeDeclarationTypeLoader;
    }

    public RamlTypeLoader(String content, String ramlLocation, TypeDeclarationTypeLoader typeDeclarationTypeLoader) {
        RamlModelResult ramlModelResult = RamlLoaderUtils.buildApiOrFail(content, ramlLocation);
        this.fragmentTypeLoader = this.createDelegate(ramlModelResult, ramlLocation);
        this.typeDeclarationTypeLoader = typeDeclarationTypeLoader;
    }

    private AbstractTypeDeclarationLoader createDelegate(RamlModelResult ramlModelResult, String ramlLocation) {
        AbstractTypeDeclarationLoader result;
        switch (ramlModelResult.getFragment()) {
            case DataType: {
                result = new DataTypeTypeDeclarationLoader(ramlModelResult);
                break;
            }
            case Library: {
                result = new LibraryTypeDeclarationLoader(ramlModelResult);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported [%s] fragment in RAML file '%s'.", ramlModelResult.getFragment() == null ? "" : ramlModelResult.getFragment(), ramlLocation));
            }
        }
        return result;
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        return this.load(typeIdentifier, null);
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
        return this.fragmentTypeLoader.load(typeIdentifier).flatMap(typeDeclaration -> this.typeDeclarationTypeLoader.load((TypeDeclaration)typeDeclaration, typeIdentifier, typeAlias));
    }
}

