/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.features.api;

import java.util.Optional;
import org.mule.runtime.api.config.Feature;

public enum MuleRuntimeFeature implements Feature
{
    HONOUR_RESERVED_PROPERTIES("When enabled, reserved properties such as 'app.name' can't be overridden by global properties (overrides are be ignored).", "MULE-17659", "4.3.0", "mule.honour.reserved.properties", null),
    HANDLE_SPLITTER_EXCEPTION("When enabled, DataWeave correctly handles internal exceptions while splitting a payload, preventing subsequent serialization errors.", "DW-383", "4.4.0", "mule.dw.handle_splitter_exception", null),
    BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER("When enabled, batch aggregators with fixed size aggregators commit only when a full block is processed.", "MULE-19218", "Never", "mule.batch.fixed.aggregator.transaction.record.buffer", null),
    COMPUTE_CONNECTION_ERRORS_IN_STATS("When enabled, connection errors are computed as part of alerts triggering.", "MULE-19020", "4.4.0", "mule.compute.connection.errors.in.stats", null),
    TO_STRING_TRANSFORMER_TRANSFORM_ITERATOR_ELEMENTS("When enabled, managed cursor iterators transformed to strings show the representation of the elements instead of generic value `org.mule.runtime.core.internal.streaming.object.-ManagedCursorIteratorProvider$ManagedCursorIterator@.`", "MULE-19323", "4.4.0", "mule.transformer.toString.transformIteratorElements", null),
    ENABLE_POLICY_ISOLATION("When enabled, Mule manages extensions imported by a policy in complete isolation from the extensions imported by the Mule application. Also, validations prevent the use of explicit configurations that the application declared as part of the policy initialization.", "MULE-19226", "4.4.0", "mule.enable.policy.isolation", null),
    ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR("When enabled, the Mule XML DSL parser fails when deploying an application that declares a schema that cannot be located. Otherwise, the parser fails if the application also makes use of the namespace to which such a schema is bound.", "EE-7827", "4.4.0", "mule.entityResolver.failOnFirstError", null),
    ENABLE_PROFILING_SERVICE("When enabled, Mule runtime profiling capabilities become available.", "MULE-19588", "", "mule.enable.profiling.service", null),
    SET_VARIABLE_WITH_NULL_VALUE("When enabled, the Set Variable component creates a variable even if its value is `null`.", "MULE-19443", "4.4.0", "mule.setVariable.WithNullValue", null),
    START_EXTENSION_COMPONENTS_WITH_ARTIFACT_CLASSLOADER("When enabled, extensions can load exported resources only from the deployable artifacts (application, policy, domain).", "MULE-19815", "4.4.0", "mule.startExtensionComponentsWithArtifactClassloader", null),
    DW_REMOVE_SHADOWED_IMPLICIT_INPUTS("When enabled, DataWeave will remove implicit inputs when a variable with the same name is declared at the root level.", "DW-893", "4.4.0", "mule.dw.remove_shadowed_implicit_inputs", null),
    DW_HONOUR_MIXED_CONTENT_STRUCTURE("When this property is set to true, DataWeave retains a mixed-content structure instead of grouping text with mixed content into a single text field.", "W-11071481", "4.5.0", "com.mulesoft.dw.xml_reader.honourMixedContentStructure", null),
    ENFORCE_ERROR_TYPES_VALIDATION("When enabled, error types validations will be enforced, even for error handlers/components that are not being referenced.", "MULE-19879", "4.5.0", null, null),
    DISABLE_ATTRIBUTE_PARAMETER_WHITESPACE_TRIMMING("When enabled, the Runtime will trim whitespaces from parameter values defined at the attribute level in the dsl", "MULE-19803", "4.5.0", "mule.disable.attribute.parameter.whitespace.trimming", null),
    DISABLE_POJO_TEXT_CDATA_WHITESPACE_TRIMMING("When enabled, the Runtime will trim whitespaces from CDATA text parameter of pojos in the dsl", "MULE-20048", "4.5.0", "mule.disable.pojo.text.parameter.whitespace.trimming", null),
    DEFAULT_ERROR_HANDLER_NOT_ROLLBACK_IF_NOT_CORRESPONDING("When enabled, the default error handler added by the runtime will not rollback a transaction that should not be rollback by it", "MULE-19919", "4.5.0", "mule.enable.default.errorhandler.not.rollback.incorrect.tx", null),
    ENFORCE_REQUIRED_EXPRESSION_VALIDATION("When enabled, expression validations will be enforced for targetValue, not allowing a literal value.", "MULE-19987", "4.5.0", "mule.enforce.expression.validation", null),
    ENFORCE_EXPRESSION_VALIDATION("When enabled, expression validations will be enforced for all DataWeave expressions.", "MULE-19967", "4.5.0", "mule.enforce.dw.expression.validation", null),
    FORCE_RUNTIME_PROFILING_CONSUMERS_ENABLEMENT("When enabled, profiling consumers implemented by the runtime will be enabled by default.", "MULE-19967", "", "mule.force.runtime.profiling.consumers.enablement", null),
    PARALLEL_FOREACH_FLATTEN_MESSAGE("When enabled, if the items to iterate over on a parallel-foreach scope are messages (such as the output of an operation that returns Result objects), they will be flattened in a way that is consistent with what the foreach scope does.", "MULE-20067", "4.5.0", "mule.parallelForeach.flattenMessage", null),
    DISABLE_REGISTRY_BOOTSTRAP_OPTIONAL_ENTRIES("When enabled, `optional` attribute in entries in a `registry-bootstrap.properties` will be ignored.", "W-10736301", "4.5.0", "mule.disable.registryBootstrapOptionalEntries", null),
    DISABLE_APPLY_OBJECT_PROCESSOR("When enabled, org.mule.runtime.core.privileged.registry.ObjectProcessor implementations will not be applied on objects registered into the `SimpleRegistry`.", "MULE-11737", "4.5.0", "mule.disable.applyObjectProcessor", null),
    ENABLE_BYTE_BUDDY_OBJECT_CREATION("When enabled, the Objects factories will be created with Byte Buddy instead of CGLIB.", "W-10672687", "4.4.0", "mule.enable.byteBuddy.objectCreation", null),
    VALIDATE_APPLICATION_MODEL_WITH_REGION_CLASSLOADER("When enabled, the application model will be validated with the region classloader. When disabled, it will be validated with the application classloader.", "W-10808757", "4.5.0", "mule.deployment.validateAppModelWithRegionClassloader", null),
    MULE_PRINT_DETAILED_COMPOSITE_EXCEPTION_LOG("When enabled, AbstractForkJoinRouter based processors, such as ParallelForEach and ScatterGather routers, will show detailed error information for their failed routes.", "W-10965130", "4.5.0", "mule.detailedCompositeRoutingExceptionLog", null),
    HONOUR_ERROR_MAPPINGS_WHEN_POLICY_APPLIED_ON_OPERATION("When enabled, the operation policy's error resolution is ignored so that the error mappings of the processor on which the policy was applied are set successfully", "W-11147961", "4.5.0", "mule.honourErrorMappingsWhenPolicyAppliedOnOperation", null),
    SUPPRESS_ERRORS("When enabled, error suppression will happen. This will affect, for example, the Web Service Consumer connector and the Until Successful scope that will always report errors from their corresponding namespaces (MULE and WSC). Suppressed errors will be treated as underlying causes.", "W-11308645", "Always", "mule.suppress.mule.exceptions", null),
    RETHROW_EXCEPTIONS_IN_IDEMPOTENT_MESSAGE_VALIDATOR("When enabled, internal exceptions when processing an event in the 'idempotent-message-validator' will be rethrown instead of throwing a general MULE:DUPLICATE_MESSAGE.", "W-11529823", "4.5.0", "mule.rethrowExceptionsInIdempotentMessageValidator", null),
    FOREACH_ROUTER_REJECTS_MAP_EXPRESSIONS("When enabled, the 'foreach' router will generate an IllegalArgumentException if the collection expression evaluates to a java.util.Map.", "W-12207110", "4.5.0", "mule.foreachRouterRejectsMapExpressions", null),
    HONOUR_INSECURE_TLS_CONFIGURATION("When enabled, the insecure TLS configuration will be honoured even if there are fields of the TrustStore configured.", "W-10822938", "4.5.0", "mule.honour.insecure.tls.configuration", null),
    USE_TRANSACTION_SINK_INDEX("When enabled, flux sinks will be cached using index as part of the key. If a sink is already in use, new sink will be created\nto avoid deadlock.", "W-12128703", "Always", "mule.transaction.sink.index", null),
    SUPPORT_NATIVE_LIBRARY_DEPENDENCIES("When enabled, if an application access a native library, the rest of its declared native libraries are also loaded. This prevents errors like UnsatisfiedLinkError when the accessed native library depends on another native library. Libraries must be declared at the sharedLibraries configuration following the dependency order, meaning that if library A depends on library B, then A must be declared first. Declaring the native libraries at a domain is also supported.", "W-11855052", "4.5.0", "mule.support.native.library.dependencies", null),
    PUT_TRACE_ID_AND_SPAN_ID_IN_MDC("When enabled, the trace id and span id will be added to the MDC when available.", "W-12979787", "Never", "mule.put.trace.id.and.span.id.in.mdc", null),
    ADD_MULE_SPECIFIC_TRACING_INFORMATION_IN_TRACE_STATE("When enabled the ancestor-mule-span-id value will be added in the trace state when a span is propagated.", "W-13215870", "Never", "mule.enable.mule.specific.tracing.information", null),
    CREATE_CHILD_POLICY_CONTEXT_FOR_PARALLEL_SCOPES("When enabled, a new (Source) Policy Context is created for the execution of parallel scopes: ParallelForeach, ScatterGather and Async", "W-13509911", "4.5.0", "mule.enable.policy.context.parallel.scopes", null),
    DISABLE_JMX_FOR_COMMONS_POOL2("When enabled, MBeans will not be registered for commons-pool2.", "W-12422473", "4.6.0", "mule.disableJmx.for.commons.pool2", null),
    DISABLE_SCHEDULER_LOGGING("When enabled, the Scheduler does not log exceptions.", "W-13881167", "4.6.0", "mule.disable.scheduler.logging", null),
    ERROR_AND_ROLLBACK_TX_WHEN_TIMEOUT("When enabled, when a (local or xa) transaction reached timeout, an error will be thrown that can be handled using error handling", "W-14608096", "4.6.1", "mule.tx.error.when.timeout", null),
    DISABLE_XML_SDK_IMPLICIT_CONFIGURATION_CREATION("When enabled, implicit configuration for the XML SDK won't be created.", "W-10634129", "4.7.0", "mule.disableXmlSdkImplicitConfigurationCreation", null),
    ENABLE_XML_SDK_MDC_RESET("When enabled, the MDC context will reset after XML SDK Operation has been executed.", "W-15206528", "4.8.0", "mule.enable.xml.sdk.mdc.reset", null),
    UNSUPPORTED_EXTENSIONS_CLIENT_RUN_ASYNC("When enabled, org.mule.runtime.extension.api.client.ExtensionsClient deprecated methods (executeAsync(String, String, OperationParameters) and execute(String, String, OperationParameters)) will throw an UnsupportedOperationException.", "W-15399821", "4.8.0", "mule.unsupportedExtensionsClientRunAsync", "21"),
    ENFORCE_IMPORT_TARGET_SAME_TYPE("When enabled, root element of `import` targets will validated to be the same as the importing config.", "W-15509819", "4.8.0", null, null),
    HONOUR_PERSISTED_FLOW_STATE("When enabled, flows will honour the state configured in flows.deployment.properties when restarting the app, regardless of the initial state. This will only apply to Standalone/Hybrid deployments.", "W-15750334", "4.8.0", "mule.honour.persisted.flow.state", null),
    DISABLE_OPTIMISED_NOTIFICATION_HANDLER_DYNAMIC_RESOLUTION_UPDATE_BASED_ON_DELEGATE("When disabled, dynamic resolution of notification handling will not happen after the mule artifact is initialized. This can result in race conditions that can affect monitoring metrics.", "W-16828516", "Never", "mule.disable.optimised.notification.handler.dynamic.resolution.update.based.on.delegate", null),
    NTLM_AVOID_SEND_PAYLOAD_ON_TYPE_1("When enabled, body contents will not be sent on NTLM type 1 requests. This saves resources by not sending a payload that will never be consumed (the server will reject it until the dance is completed).", "W-17107281", "4.9.0", "mule.ntlm.avoid.send.payload.on.type1", null),
    FORK_JOIN_COMPLETE_CHILDREN_ON_TIMEOUT("When enabled, the processors that perform fork and join work (currently Scatter Gather and Parallel For Each), will take care of completing the child event contexts when there is a timeout.", "W-16941297", "4.10.0", "mule.forkJoin.completeChildContextsOnTimeout", null),
    ENABLE_REPEATABLE_STREAMING_BYTES_EAGER_READ("When enabled, cursors from repeatable streams 'read' methods will return immediately after readily available data has been read. If disabled, 'read' methods will not return until the requested 'len' has been read. Setting this to 'true' is useful, for instance, so that SSE events sent over HTTP can be processed as they arrive instead of being buffered by repeatable streaming.", "W-18716253", "Never", "mule.repeatableStreaming.bytes.eagerRead", null),
    ENABLE_REDELIVERY_POLICY_ENCODE_SECURE_HASH("When set to true, the result of the encryption of the payload will be encoded to Hexadecimal. This only affects the case when there is no ExpressionID set by the user.", "W-18584560", "4.11.0", "mule.redeliveryPolicy.encode.secureHash", null),
    RAISE_CANCELLED_ERROR_ON_FORCEFUL_SHUTDOWN("When set to true, when the time of the graceful shutdown expires and a forceful shutdown is done, cancelled events will raise a 'MULE:CANCELLED' error instead of 'MULE:UNKNOWN'.", "W-19648397", "4.11.0", "mule.forcefulShutdown.raiseCancelledError", null),
    DISALLOW_UNTIL_SUCCESSFUL_RETRIES_ON_CRITICAL_ERRORS("When set to true, if a 'MULE:CRITICAL' error is raised within an 'until-successful' the event will NOT be retried.", "W-19648397", "4.11.0", "mule.untilSuccessful.retryOnCriticalError.disallow", null);

    private final String description;
    private final String issueId;
    private final String enabledByDefaultSince;
    private final String overridingSystemPropertyName;
    private final String minJavaVersion;

    private MuleRuntimeFeature(String description, String issueId, String enabledByDefaultSince, String overridingSystemPropertyName, String minJavaVersion) {
        this.description = description;
        this.issueId = issueId;
        this.enabledByDefaultSince = enabledByDefaultSince;
        this.overridingSystemPropertyName = overridingSystemPropertyName;
        this.minJavaVersion = minJavaVersion;
    }

    public String getName() {
        return this.name();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Override
    public String getSince() {
        return this.getEnabledByDefaultSince();
    }

    @Override
    public String getEnabledByDefaultSince() {
        return this.enabledByDefaultSince;
    }

    @Override
    public Optional<String> getOverridingSystemPropertyName() {
        return Optional.ofNullable(this.overridingSystemPropertyName);
    }

    @Override
    public Optional<String> getMinJavaVersion() {
        return Optional.ofNullable(this.minJavaVersion);
    }
}

