/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.privileged.util.ComponentDeclarationUtils;

abstract class AbstractErrorMappingValidation
implements Validation {
    AbstractErrorMappingValidation() {
    }

    @Override
    public final Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(OperationModel.class).map(opModel -> !ComponentDeclarationUtils.isNoErrorMapping(opModel) && component.getParameter("Error Mappings", "errorMappings") != null && component.getParameter("Error Mappings", "errorMappings").getValue().getValue().isPresent()).orElse(false));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst errorMappingsParam = component.getParameter("Error Mappings", "errorMappings");
        return errorMappingsParam.getValue().reduce(l -> Optional.empty(), mappings -> this.validateErrorMapping(component, errorMappingsParam, (List<ErrorMapping>)mappings));
    }

    protected abstract Optional<ValidationResultItem> validateErrorMapping(ComponentAst var1, ComponentParameterAst var2, List<ErrorMapping> var3);

    protected final boolean isErrorMappingWithSourceAny(ErrorMapping model) {
        return "ANY".equals(model.getSource());
    }
}

