/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.management.stats;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.annotation.Experimental;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.management.stats.ArtifactMeterProvider;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.core.api.management.stats.PayloadStatistics;
import org.mule.runtime.core.internal.management.stats.ApplicationStatistics;
import org.mule.runtime.core.internal.management.stats.DefaultFlowsSummaryStatistics;
import org.mule.runtime.core.internal.management.stats.FlowsSummaryStatisticsV2;
import org.mule.runtime.metrics.api.MeterProvider;

@NoExtend
public class AllStatistics {
    private boolean isStatisticsEnabled = Boolean.getBoolean("mule.enable.statistics");
    private long startTime;
    private final ApplicationStatistics appStats;
    private final FlowsSummaryStatistics flowSummaryStatistics;
    private final FlowsSummaryStatistics flowSummaryStatisticsV2;
    private final Map<String, FlowConstructStatistics> flowConstructStats = new HashMap<String, FlowConstructStatistics>();
    private final Map<String, PayloadStatistics> payloadStatistics = Collections.emptyMap();
    private ArtifactMeterProvider meterProvider;

    public AllStatistics() {
        this.clear();
        this.appStats = new ApplicationStatistics(this);
        this.flowSummaryStatistics = new DefaultFlowsSummaryStatistics(this.isStatisticsEnabled);
        this.flowSummaryStatisticsV2 = new FlowsSummaryStatisticsV2(this.isStatisticsEnabled);
        this.appStats.setEnabled(this.isStatisticsEnabled);
        this.add(this.appStats);
    }

    public synchronized void clear() {
        for (FlowConstructStatistics statistics : this.getServiceStatistics()) {
            statistics.clear();
        }
        this.startTime = System.currentTimeMillis();
    }

    public boolean isEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setEnabled(boolean enable) {
        this.isStatisticsEnabled = enable;
        for (FlowConstructStatistics statistics : this.flowConstructStats.values()) {
            statistics.setEnabled(enable);
        }
    }

    @Deprecated
    @Experimental
    public void enablePayloadStatistics(boolean b) {
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void add(FlowConstructStatistics stat) {
        if (stat != null) {
            stat.setEnabled(this.isStatisticsEnabled);
            if (this.meterProvider != null) {
                stat.trackUsingMeterProvider(this.meterProvider);
            }
            this.flowConstructStats.put(stat.getName(), stat);
        }
    }

    public synchronized void remove(FlowConstructStatistics stat) {
        if (stat != null) {
            this.flowConstructStats.remove(stat.getName());
        }
    }

    public synchronized Collection<FlowConstructStatistics> getServiceStatistics() {
        return this.flowConstructStats.values();
    }

    public FlowConstructStatistics getApplicationStatistics() {
        return this.appStats;
    }

    public FlowsSummaryStatistics getFlowSummaryStatistics() {
        return this.flowSummaryStatistics;
    }

    @Deprecated
    @Experimental
    public Collection<PayloadStatistics> getPayloadStatistics() {
        return this.payloadStatistics.values();
    }

    @Experimental
    public FlowsSummaryStatistics getFlowSummaryStatisticsV2() {
        return this.flowSummaryStatisticsV2;
    }

    @Deprecated
    @Experimental
    public PayloadStatistics computePayloadStatisticsIfAbsent(Component component) {
        return this.payloadStatistics.computeIfAbsent(component.getLocation().getLocation(), loc -> {
            PayloadStatistics statistics = new PayloadStatistics((String)loc, component.getIdentifier().toString());
            statistics.setEnabled(this.isPayloadStatisticsEnabled());
            return statistics;
        });
    }

    @Deprecated
    @Experimental
    public PayloadStatistics getPayloadStatistics(String componentLocation) {
        return this.payloadStatistics.get(componentLocation);
    }

    @Deprecated
    @Experimental
    public boolean isPayloadStatisticsEnabled() {
        return false;
    }

    public static void configureComputeConnectionErrorsInStats() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.COMPUTE_CONNECTION_ERRORS_IN_STATS, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(MuleVersion.v4_4_0)).isPresent());
    }

    public void trackUsingMeterProvider(MeterProvider meterProvider, String artifactId) {
        this.meterProvider = new ArtifactMeterProvider(meterProvider, artifactId);
        this.flowSummaryStatistics.trackUsingMeterProvider(this.meterProvider);
        this.flowSummaryStatisticsV2.trackUsingMeterProvider(this.meterProvider);
        this.flowConstructStats.values().forEach(flowConstructStatsValue -> flowConstructStatsValue.trackUsingMeterProvider(this.meterProvider));
    }
}

