/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ComponentVisibility;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.notification.NotificationModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ComposedOperationModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.AttributesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.NestedChainModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.NestedRouteModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.utils.ResolvedMinMuleVersion;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.InputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.MetadataKeyModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.OutputResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.RoutesChainInputTypesResolverModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.metadata.ScopeChainInputTypeResolverModelParser;
import org.mule.runtime.module.extension.mule.internal.execution.MuleOperationExecutor;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterGroupModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.VoidOutputModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.utils.AggregatedErrorsCharacteristic;
import org.mule.runtime.module.extension.mule.internal.loader.parser.utils.Characteristic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MuleSdkOperationModelParser
extends BaseMuleSdkExtensionModelParser
implements OperationModelParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleSdkOperationModelParser.class);
    private static final String BODY_CHILD = "body";
    private static final String DESCRIPTION_PARAMETER = "description";
    private static final String DISPLAY_PARAMETER = "displayName";
    private static final String NAME_PARAMETER = "name";
    private static final String SUMMARY_PARAMETER = "summary";
    private static final String TYPE_PARAMETER = "type";
    private static final String VISIBILITY_PARAMETER = "visibility";
    private static final String PAYLOAD_TYPE_ELEMENT_NAME = "payload-type";
    private static final String OUTPUT_ELEMENT_NAME = "output";
    private static final String MIN_MULE_VERSION = "4.5";
    private final ComponentAst operation;
    private final TypeLoader typeLoader;
    private final ExtensionModelHelper extensionModelHelper;
    private final Characteristic<Boolean> isBlocking = new Characteristic.IsBlockingCharacteristic();
    private final Characteristic<Boolean> isConnected = new Characteristic.IsConnectedCharacteristic();
    private final Characteristic<List<NotificationModel>> notificationModels = new Characteristic.AggregatedNotificationsCharacteristic();
    private final Characteristic.FilteringCharacteristic<Boolean> isTransactional = new Characteristic.IsTransactionalCharacteristic();
    private final Characteristic<List<ErrorModelParser>> errorModels;
    private String name;

    public MuleSdkOperationModelParser(ComponentAst operation, String namespace, TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        this.operation = operation;
        this.typeLoader = typeLoader;
        this.extensionModelHelper = extensionModelHelper;
        this.errorModels = new AggregatedErrorsCharacteristic(namespace);
        this.parseStructure();
    }

    private void parseStructure() {
        this.name = (String)this.getParameter(this.operation, NAME_PARAMETER);
    }

    private OutputModelParser asOutputModelParser(ComponentAst outputTypeElement) {
        String type = (String)this.getParameter(outputTypeElement, TYPE_PARAMETER);
        return this.typeLoader.load(type).map(mt -> new DefaultOutputModelParser((MetadataType)mt, false)).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Component <%s:%s> defines %s as '%s' but such type is not defined in the application", outputTypeElement.getIdentifier().getNamespace(), outputTypeElement.getIdentifier().getName(), TYPE_PARAMETER, type)));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.getOptionalParameter(this.operation, DESCRIPTION_PARAMETER).orElse("");
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.singletonList(new ComposedOperationModelProperty());
    }

    @Override
    public boolean hasStreamingConfiguration() {
        return false;
    }

    @Override
    public boolean hasTransactionalAction() {
        return false;
    }

    @Override
    public boolean hasReconnectionStrategy() {
        return false;
    }

    @Override
    public boolean propagatesConnectivityError() {
        return false;
    }

    @Override
    public Stream<NotificationModel> getEmittedNotificationsStream(Function<String, Optional<NotificationModel>> notificationMapper) {
        return this.notificationModels.getValue().stream();
    }

    @Override
    public OutputModelParser getOutputType() {
        return this.asOutputModelParser(this.getOutputPayloadTypeElement());
    }

    @Override
    public OutputModelParser getAttributesOutputType() {
        return this.getOutputAttributesTypeElement().map(this::asOutputModelParser).orElse(VoidOutputModelParser.INSTANCE);
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return this.getSingleChild(this.operation, "parameters").map(parameters -> Collections.singletonList(new MuleSdkParameterGroupModelParser((ComponentAst)parameters, this.typeLoader, this.extensionModelHelper))).orElse(Collections.emptyList());
    }

    @Override
    public ComponentVisibility getComponentVisibility() {
        return this.getOptionalParameter(this.operation, VISIBILITY_PARAMETER).map(ComponentVisibility::valueOf).orElse(ComponentVisibility.PUBLIC);
    }

    @Override
    public List<NestedRouteModelParser> getNestedRouteParsers() {
        return Collections.emptyList();
    }

    @Override
    public Optional<CompletableComponentExecutorModelProperty> getExecutorModelProperty() {
        return Optional.of(new CompletableComponentExecutorModelProperty((model, p) -> new MuleOperationExecutor(model)));
    }

    @Override
    public Optional<NestedChainModelParser> getNestedChainParser() {
        return Optional.empty();
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking.getValue();
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean isScope() {
        return false;
    }

    @Override
    public boolean isRouter() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected.getValue();
    }

    @Override
    public boolean hasConfig() {
        return false;
    }

    @Override
    public boolean supportsStreaming() {
        return false;
    }

    @Override
    public boolean isTransactional() {
        return (Boolean)this.isTransactional.getValue();
    }

    @Override
    public boolean isAutoPaging() {
        return false;
    }

    @Override
    public Optional<ExecutionType> getExecutionType() {
        return Optional.of(ExecutionType.CPU_LITE);
    }

    @Override
    public Optional<MediaTypeModelProperty> getMediaTypeModelProperty() {
        return Optional.empty();
    }

    @Override
    public Optional<ExceptionHandlerModelProperty> getExceptionHandlerModelProperty() {
        return Optional.empty();
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return this.getSingleChild(this.operation, "deprecated").map(this::buildDeprecationModel);
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        String summary = this.getOptionalParameter(this.operation, SUMMARY_PARAMETER).orElse(null);
        String displayName = this.getOptionalParameter(this.operation, DISPLAY_PARAMETER).orElse(null);
        if (!StringUtils.isBlank(displayName) || !StringUtils.isBlank(summary)) {
            return Optional.of(DisplayModel.builder().summary(summary).displayName(displayName).build());
        }
        return Optional.empty();
    }

    @Override
    public List<ErrorModelParser> getErrorModelParsers() {
        return this.errorModels.getValue();
    }

    @Override
    public Optional<ResolvedMinMuleVersion> getResolvedMinMuleVersion() {
        return Optional.of(new ResolvedMinMuleVersion(this.name, new MuleVersion(MIN_MULE_VERSION), String.format("Operation %s has min mule version %s because the Mule Sdk was introduced in that version.", this.name, MIN_MULE_VERSION)));
    }

    @Override
    public Set<String> getSemanticTerms() {
        return Collections.emptySet();
    }

    @Override
    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return Optional.empty();
    }

    @Override
    public Optional<OutputResolverModelParser> getOutputResolverModelParser() {
        return Optional.empty();
    }

    @Override
    public Optional<AttributesResolverModelParser> getAttributesResolverModelParser() {
        return Optional.empty();
    }

    @Override
    public List<InputResolverModelParser> getInputResolverModelParsers() {
        return Collections.emptyList();
    }

    @Override
    public Optional<MetadataKeyModelParser> getMetadataKeyModelParser() {
        return Optional.empty();
    }

    @Override
    public Optional<ScopeChainInputTypeResolverModelParser> getScopeChainInputTypeResolverModelParser() {
        return Optional.empty();
    }

    @Override
    public Optional<RoutesChainInputTypesResolverModelParser> getRoutesChainInputTypesResolverModelParser() {
        return Optional.empty();
    }

    private ComponentAst getOutputPayloadTypeElement() {
        return this.getOutputElement(PAYLOAD_TYPE_ELEMENT_NAME).orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing its <%s> declaration", this.getName(), PAYLOAD_TYPE_ELEMENT_NAME)));
    }

    private Optional<ComponentAst> getOutputAttributesTypeElement() {
        return this.getOutputElement("attributes-type");
    }

    private Optional<ComponentAst> getOutputElement(String elementName) {
        ComponentAst output = this.operation.directChildrenStreamByIdentifier(null, OUTPUT_ELEMENT_NAME).findFirst().orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing its <%s> declaration", this.getName(), OUTPUT_ELEMENT_NAME)));
        return output.directChildrenStreamByIdentifier(null, elementName).findFirst();
    }

    private ComponentAst getBody() {
        return this.getSingleChild(this.operation, BODY_CHILD).get();
    }

    private Stream<Characteristic.ComponentAstWithHierarchy> expandOperationWithoutModel(Map<String, MuleSdkOperationModelParser> operationModelParsersByName, Set<String> visitedOperations, Characteristic.ComponentAstWithHierarchy componentAst, Predicate<Characteristic.ComponentAstWithHierarchy> filterCondition, Predicate<Characteristic.ComponentAstWithHierarchy> ignoreCondition) {
        MuleSdkOperationModelParser operationParser = operationModelParsersByName.get(componentAst.getComponentAst().getIdentifier().getName());
        if (operationParser != null) {
            return operationParser.getOperationsAstRecursiveStream(operationModelParsersByName, visitedOperations, filterCondition, ignoreCondition);
        }
        return Stream.empty();
    }

    private Stream<Characteristic.ComponentAstWithHierarchy> getOperationsAstRecursiveStream(Map<String, MuleSdkOperationModelParser> operationModelParsersByName) {
        return this.getOperationsAstRecursiveStream(operationModelParsersByName, componentAst -> false, componentAst -> false);
    }

    private Stream<Characteristic.ComponentAstWithHierarchy> getOperationsAstRecursiveStream(Map<String, MuleSdkOperationModelParser> operationModelParsersByName, Predicate<Characteristic.ComponentAstWithHierarchy> filterCondition, Predicate<Characteristic.ComponentAstWithHierarchy> ignoreCondition) {
        HashSet<String> visitedOperations = new HashSet<String>();
        return this.getOperationsAstRecursiveStream(operationModelParsersByName, visitedOperations, filterCondition, ignoreCondition);
    }

    private Stream<Characteristic.ComponentAstWithHierarchy> getOperationsAstRecursiveStream(Map<String, MuleSdkOperationModelParser> operationModelParsersByName, Set<String> visitedOperations, Predicate<Characteristic.ComponentAstWithHierarchy> filterCondition, Predicate<Characteristic.ComponentAstWithHierarchy> ignoreCondition) {
        if (!visitedOperations.add(this.getName())) {
            return Stream.empty();
        }
        HashSet filtered = new HashSet();
        return AstTraversalDirection.TOP_DOWN.recursiveStreamWithHierarchy(Stream.of(this.getBody())).map(Characteristic.ComponentAstWithHierarchy::new).flatMap(componentAstWithHierarchy -> {
            ComponentAst componentAst = componentAstWithHierarchy.getComponentAst();
            List<ComponentAst> hierarchy = componentAstWithHierarchy.getHierarchy();
            LOGGER.trace("Iteration is processing the ast: [{}] -> [{}]", hierarchy, (Object)componentAst);
            if (filtered.contains(componentAst) || ignoreCondition.test((Characteristic.ComponentAstWithHierarchy)componentAstWithHierarchy)) {
                return Stream.empty();
            }
            if (filterCondition.test((Characteristic.ComponentAstWithHierarchy)componentAstWithHierarchy)) {
                this.recursiveAddToFiltered(componentAst, filtered);
                return Stream.empty();
            }
            Optional<OperationModel> operationModel = componentAst.getModel(OperationModel.class);
            if (operationModel.isPresent()) {
                return Stream.of(componentAstWithHierarchy);
            }
            if (componentAst.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.UNKNOWN)) {
                return this.expandOperationWithoutModel(operationModelParsersByName, visitedOperations, (Characteristic.ComponentAstWithHierarchy)componentAstWithHierarchy, filterCondition, ignoreCondition);
            }
            return Stream.empty();
        });
    }

    private void recursiveAddToFiltered(ComponentAst ast, Set<ComponentAst> filtered) {
        filtered.add(ast);
        for (ComponentAst child : ast.directChildren()) {
            this.recursiveAddToFiltered(child, filtered);
        }
    }

    public void computeCharacteristics(Map<String, MuleSdkOperationModelParser> operationModelParsersByName) {
        this.computeCharacteristicsWithoutFiltering(Arrays.asList(this.isBlocking, this.isConnected, this.notificationModels, this.errorModels), operationModelParsersByName);
        this.computeCharacteristicsWithFiltering(Collections.singletonList(this.isTransactional), operationModelParsersByName);
    }

    private void computeCharacteristicsWithoutFiltering(List<Characteristic<?>> characteristics, Map<String, MuleSdkOperationModelParser> operationModelParsersByName) {
        this.getOperationsAstRecursiveStream(operationModelParsersByName).anyMatch(operationAst -> {
            for (Characteristic characteristic : characteristics) {
                characteristic.computeFrom((Characteristic.ComponentAstWithHierarchy)operationAst);
            }
            return this.areAllCharacteristicsWithDefinitiveValue(characteristics);
        });
        characteristics.stream().filter(c -> !c.hasValue()).forEach(Characteristic::setWithDefault);
    }

    private void computeCharacteristicsWithFiltering(List<Characteristic.FilteringCharacteristic<?>> characteristics, Map<String, MuleSdkOperationModelParser> operationModelParsersByName) {
        for (Characteristic.FilteringCharacteristic<?> characteristic : characteristics) {
            this.getOperationsAstRecursiveStream(operationModelParsersByName, characteristic::filterComponent, characteristic::ignoreComponent).anyMatch(operationAst -> {
                characteristic.computeFrom((Characteristic.ComponentAstWithHierarchy)operationAst);
                return characteristic.hasDefinitiveValue();
            });
        }
        characteristics.stream().filter(c -> !c.hasValue()).forEach(Characteristic::setWithDefault);
    }

    private boolean areAllCharacteristicsWithDefinitiveValue(List<Characteristic<?>> characteristics) {
        return characteristics.stream().allMatch(Characteristic::hasDefinitiveValue);
    }
}

