/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.properties;

import java.util.Collection;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.api.dsl.model.ConfigurationParameters;
import org.mule.runtime.config.internal.dsl.model.DefaultConfigurationParameters;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public final class ConfigurationPropertiesProviderFactoryUtils {
    public static ConfigurationParameters resolveConfigurationParameters(DefaultConfigurationParameters.Builder configurationParametersBuilder, ComponentAst component, UnaryOperator<String> localResolver) {
        component.getModel(ParameterizedModel.class).ifPresent(pmzd -> pmzd.getParameterGroupModels().forEach(pmg -> {
            if (pmg.isShowInDsl()) {
                DslElementSyntax childSyntax = component.getGenerationInformation().getSyntax().get().getChild(pmg.getName()).get();
                ComponentIdentifier dslGroupIdentifier = ComponentIdentifier.builder().name(childSyntax.getElementName()).namespace(childSyntax.getPrefix()).namespaceUri(childSyntax.getNamespace()).build();
                DefaultConfigurationParameters.Builder dslGroupParametersBuilder = DefaultConfigurationParameters.builder();
                ConfigurationPropertiesProviderFactoryUtils.resolveParamGroupConfigurationParameters(dslGroupParametersBuilder, component, pmg, localResolver);
                configurationParametersBuilder.withComplexParameter(dslGroupIdentifier, dslGroupParametersBuilder.build());
            } else {
                ConfigurationPropertiesProviderFactoryUtils.resolveParamGroupConfigurationParameters(configurationParametersBuilder, component, pmg, localResolver);
            }
        }));
        component.directChildrenStream().forEach(child -> configurationParametersBuilder.withComplexParameter(child.getIdentifier(), ConfigurationPropertiesProviderFactoryUtils.resolveConfigurationParameters(DefaultConfigurationParameters.builder(), child, localResolver)));
        return configurationParametersBuilder.build();
    }

    private static void resolveParamGroupConfigurationParameters(final DefaultConfigurationParameters.Builder configurationParametersBuilder, ComponentAst component, ParameterGroupModel parameterGroup, final UnaryOperator<String> localResolver) {
        parameterGroup.getParameterModels().forEach(pm -> {
            final ComponentParameterAst param = component.getParameter(parameterGroup.getName(), pm.getName());
            if (param != null) {
                param.getModel().getType().accept(new MetadataTypeVisitor((ParameterModel)pm){
                    final /* synthetic */ ParameterModel val$pm;
                    {
                        this.val$pm = parameterModel;
                    }

                    @Override
                    public void visitArrayType(ArrayType arrayType) {
                        this.getParamComponentIdentifier(param).ifPresent(paramComponentIdentifier -> {
                            DefaultConfigurationParameters.Builder childParametersBuilder = DefaultConfigurationParameters.builder();
                            this.visitMultiple(localResolver, param, childParametersBuilder);
                            configurationParametersBuilder.withComplexParameter((ComponentIdentifier)paramComponentIdentifier, childParametersBuilder.build());
                        });
                    }

                    @Override
                    public void visitObject(ObjectType objectType) {
                        this.getParamComponentIdentifier(param).ifPresent(paramComponentIdentifier -> {
                            DefaultConfigurationParameters.Builder childParametersBuilder = DefaultConfigurationParameters.builder();
                            if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                                this.visitMultiple(localResolver, param, childParametersBuilder);
                            } else {
                                Object value = param.getValue().getRight();
                                if (value instanceof ComponentAst) {
                                    ConfigurationPropertiesProviderFactoryUtils.resolveConfigurationParameters(childParametersBuilder, (ComponentAst)value, localResolver);
                                }
                            }
                            configurationParametersBuilder.withComplexParameter((ComponentIdentifier)paramComponentIdentifier, childParametersBuilder.build());
                        });
                    }

                    protected Optional<ComponentIdentifier> getParamComponentIdentifier(ComponentParameterAst param2) {
                        return param2.getGenerationInformation().getSyntax().map(paramSyntax -> ComponentIdentifier.builder().namespaceUri(paramSyntax.getNamespace()).namespace(paramSyntax.getPrefix()).name(paramSyntax.getElementName()).build());
                    }

                    protected void visitMultiple(UnaryOperator<String> localResolver2, ComponentParameterAst param2, DefaultConfigurationParameters.Builder childParametersBuilder) {
                        Object value = param2.getValue().getRight();
                        if (value != null && value instanceof Collection) {
                            ((Collection)value).forEach(item -> {
                                DefaultConfigurationParameters.Builder itemBuilder = DefaultConfigurationParameters.builder();
                                if (item instanceof ComponentAst) {
                                    ConfigurationPropertiesProviderFactoryUtils.resolveConfigurationParameters(itemBuilder, (ComponentAst)item, localResolver2);
                                    childParametersBuilder.withComplexParameter(((ComponentAst)item).getIdentifier(), itemBuilder.build());
                                }
                            });
                        }
                    }

                    @Override
                    public void defaultVisit(MetadataType metadataType) {
                        configurationParametersBuilder.withSimpleParameter(this.val$pm.getName(), localResolver.apply(param.getResolvedRawValue()));
                    }
                });
            }
        });
    }
}

