/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Optional;
import org.mule.metadata.api.model.BooleanType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.WalkingDeclarationEnricher;

public class BooleanParameterDeclarationEnricher
implements WalkingDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public Optional<WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate> getWalkDelegate(ExtensionLoadingContext extensionLoadingContext) {
        if (((Boolean)extensionLoadingContext.getParameter("EXTENSION_LOADER_DONT_SET_DEFAULT_VALUE_TO_BOOLEAN_PARAMS").filter(v -> v instanceof Boolean).orElse(false)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(new WalkingDeclarationEnricher.DeclarationEnricherWalkDelegate(){

            @Override
            public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
                if (declaration.getType() instanceof BooleanType) {
                    if (declaration.getExpressionSupport() == ExpressionSupport.REQUIRED) {
                        return;
                    }
                    declaration.setRequired(false);
                    if (declaration.getDefaultValue() == null && !declaration.isConfigOverride()) {
                        declaration.setDefaultValue(String.valueOf(Boolean.FALSE));
                    }
                }
            }
        });
    }
}

