/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.core.internal.context.FlowStoppedPersistenceListener;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowStoppedDeploymentPersistenceListener
implements FlowStoppedPersistenceListener {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean shouldPersist;
    private String flowName;
    private String appName;
    public static final String START_FLOW_ON_DEPLOYMENT_PROPERTY = "startFlowOnDeployment";
    private String propertyName;
    private AtomicBoolean shouldStart;

    public FlowStoppedDeploymentPersistenceListener(String flowName, String appName) {
        this.flowName = flowName;
        this.appName = appName;
        this.propertyName = flowName + "_startFlowOnDeployment";
        this.shouldPersist = new AtomicBoolean(true);
        this.shouldStart = new AtomicBoolean(true);
    }

    @Override
    public void onStart() {
        try {
            Properties properties = DeploymentPropertiesUtils.getPersistedFlowDeploymentProperties(this.appName).orElse(new Properties());
            properties.setProperty(this.propertyName, String.valueOf(true));
            DeploymentPropertiesUtils.setPersistedFlowDeploymentProperties(this.appName, properties);
        }
        catch (IOException e) {
            this.logger.error("FlowStoppedDeploymentListener failed to process notification onStart for flow " + this.flowName, (Throwable)e);
        }
    }

    @Override
    public void onStop() {
        if (!this.shouldPersist.get()) {
            return;
        }
        try {
            Properties properties = DeploymentPropertiesUtils.getPersistedFlowDeploymentProperties(this.appName).orElse(new Properties());
            properties.setProperty(this.propertyName, String.valueOf(false));
            DeploymentPropertiesUtils.setPersistedFlowDeploymentProperties(this.appName, properties);
        }
        catch (IOException e) {
            this.logger.error("FlowStoppedDeploymentListener failed to process notification onStop for flow " + this.flowName, (Throwable)e);
        }
    }

    @Override
    public void doNotPersist() {
        this.shouldPersist.set(false);
    }

    @Override
    public Boolean shouldStart() {
        Optional<Properties> deploymentProperties = DeploymentPropertiesUtils.getPersistedFlowDeploymentProperties(this.appName);
        return deploymentProperties.isPresent() && Boolean.parseBoolean(deploymentProperties.get().getProperty(this.propertyName, "true"));
    }
}

