/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Optional;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.ast.api.validation.ImportValidationConstants;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.config.internal.validation.AbstractImportValidation;

public class ImportTargetElement
extends AbstractImportValidation {
    private final Optional<FeatureFlaggingService> featureFlaggingService;

    public ImportTargetElement(Optional<FeatureFlaggingService> featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }

    @Override
    public String getName() {
        return "Imported files have same element type";
    }

    @Override
    public String getDescription() {
        return "Import elements in config files point to files with the same element type.";
    }

    @Override
    public Validation.Level getLevel() {
        return this.featureFlaggingService.map(ffs -> ffs.isEnabled(MuleRuntimeFeature.ENFORCE_IMPORT_TARGET_SAME_TYPE)).orElse(true) != false ? Validation.Level.ERROR : Validation.Level.WARN;
    }

    @Override
    protected boolean appliesValidationFor(String resolutionFailureMessage) {
        return ImportValidationConstants.IMPORT_ROOT_ELEMENT_MISMATCH_MESSAGE_PATTERN.matcher(resolutionFailureMessage).matches();
    }
}

