/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.connection.AbstractConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.HasReconnectionConfig;

public class ClassLoaderConnectionProviderWrapper<C>
extends AbstractConnectionProviderWrapper<C> {
    protected final ClassLoader classLoader;

    public static <C> ClassLoaderConnectionProviderWrapper<C> newInstance(ConnectionProvider<C> provider, ClassLoader classLoader) {
        return provider instanceof PoolingConnectionProvider ? new PoolingClassLoaderConnectionProviderWrapper((ConnectionProvider)provider, classLoader) : new ClassLoaderConnectionProviderWrapper<C>(provider, classLoader);
    }

    private ClassLoaderConnectionProviderWrapper(ConnectionProvider<C> provider, ClassLoader classLoader) {
        super(provider);
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public C connect() throws ConnectionException {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            Object c = this.getDelegate().connect();
            return c;
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionValidationResult validate(C connection) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            ConnectionValidationResult connectionValidationResult = this.getDelegate().validate(connection);
            return connectionValidationResult;
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(C connection) {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            this.getDelegate().disconnect(connection);
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            super.initialise();
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    @Override
    public void start() throws MuleException {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            super.start();
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    @Override
    public void stop() throws MuleException {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            super.stop();
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    @Override
    public void dispose() {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
        try {
            super.dispose();
        }
        finally {
            ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
        }
    }

    @Override
    public Optional<ReconnectionConfig> getReconnectionConfig() {
        ConnectionProvider delegate = this.getDelegate();
        if (delegate instanceof HasReconnectionConfig) {
            return ((HasReconnectionConfig)((Object)delegate)).getReconnectionConfig();
        }
        return Optional.empty();
    }

    private static class PoolingClassLoaderConnectionProviderWrapper<C>
    extends ClassLoaderConnectionProviderWrapper<C>
    implements PoolingConnectionProvider<C> {
        private PoolingClassLoaderConnectionProviderWrapper(ConnectionProvider provider, ClassLoader classLoader) {
            super(provider, classLoader);
            Preconditions.checkArgument(provider instanceof PoolingConnectionProvider, "Delegate is not a pooling provider");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBorrow(C connection) {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
            try {
                this.getPoolingDelegate().onBorrow(connection);
            }
            finally {
                ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReturn(C connection) {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            ClassUtils.setContextClassLoader(thread, currentClassLoader, this.classLoader);
            try {
                this.getPoolingDelegate().onReturn(connection);
            }
            finally {
                ClassUtils.setContextClassLoader(thread, this.classLoader, currentClassLoader);
            }
        }

        private PoolingConnectionProvider<C> getPoolingDelegate() {
            return (PoolingConnectionProvider)this.getDelegate();
        }
    }
}

