/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.privileged.routing.RoutingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRoutingException
extends MuleException
implements ComposedErrorException,
ErrorMessageAwareException {
    private static final String MESSAGE_TITLE = "Error(s) were found for route(s):";
    private static final String MESSAGE_SUB_TITLE = "Detailed Error(s) for route(s):";
    private static final String LEGACY_MESSAGE_TITLE = "Exception(s) were found for route(s): ";
    private static final long serialVersionUID = -4421728527040579605L;
    private final RoutingResult routingResult;
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeRoutingException.class);

    public CompositeRoutingException(RoutingResult routingResult) {
        super(CompositeRoutingException.buildExceptionMessage(routingResult));
        this.routingResult = routingResult;
    }

    @Override
    public String getDetailedMessage() {
        Map<String, Pair<Error, String>> detailedFailures = this.getDetailedFailures();
        if (detailedFailures.isEmpty()) {
            return this.getLegacyDetailedMessage();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(super.getDetailedMessage());
        builder.append(System.lineSeparator()).append(MESSAGE_SUB_TITLE).append(System.lineSeparator());
        for (Map.Entry<String, Pair<Error, String>> entry : detailedFailures.entrySet()) {
            String detailedMessage = entry.getValue().getSecond();
            Throwable exception = entry.getValue().getFirst().getCause();
            this.appendMessageForExceptions(builder, entry.getKey(), exception, detailedMessage);
        }
        return builder.toString();
    }

    private String getLegacyDetailedMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(LEGACY_MESSAGE_TITLE).append(System.lineSeparator());
        for (Map.Entry<String, Error> entry : this.routingResult.getFailures().entrySet()) {
            MuleException muleException = ExceptionHelper.getRootMuleException(entry.getValue().getCause());
            Throwable exception = entry.getValue().getCause();
            String detailedMessage = muleException != null ? muleException.getDetailedMessage() : null;
            this.appendMessageForExceptions(builder, entry.getKey(), exception, detailedMessage);
        }
        return builder.toString();
    }

    private void appendMessageForExceptions(StringBuilder builder, String route, Throwable exception, String detailedMessage) {
        String routeSubtitle = String.format("Route %s: ", route);
        builder.append(System.lineSeparator());
        if (detailedMessage != null) {
            builder.append(routeSubtitle).append(detailedMessage);
        } else {
            builder.append(routeSubtitle).append("Caught exception in Exception Strategy: ").append(exception.getMessage());
        }
    }

    private Map<String, Pair<Error, String>> getDetailedFailures() {
        Method getDetailedFailuresMethod = null;
        Map detailedFailures = Collections.emptyMap();
        try {
            getDetailedFailuresMethod = RoutingResult.class.getMethod("getFailuresWithExceptionInfo", new Class[0]);
            detailedFailures = (Map)getDetailedFailuresMethod.invoke((Object)this.routingResult, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Invalid Invocation, Expected method getFailuresWithExceptionInfo doesn't exist");
        }
        return detailedFailures;
    }

    private static I18nMessage buildExceptionMessage(RoutingResult routingResult) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Error> routeResult : routingResult.getFailures().entrySet()) {
            Throwable routeException = routeResult.getValue().getCause();
            builder.append(System.lineSeparator()).append("\t").append("Route ").append(routeResult.getKey()).append(": ").append(routeException.getClass().getName()).append(": ").append(routeException.getMessage());
        }
        if (!routingResult.getFailuresWithExceptionInfo().isEmpty()) {
            builder.insert(0, MESSAGE_TITLE);
        } else {
            builder.insert(0, LEGACY_MESSAGE_TITLE);
        }
        return I18nMessageFactory.createStaticMessage(builder.toString());
    }

    @Override
    public List<Error> getErrors() {
        if (!this.routingResult.getFailures().isEmpty()) {
            return new ArrayList<Error>(this.routingResult.getFailures().values());
        }
        return this.routingResult.getFailuresWithExceptionInfo().values().stream().map(Pair::getFirst).collect(Collectors.toList());
    }

    @Override
    public Message getErrorMessage() {
        return Message.of(this.routingResult);
    }
}

