/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.deployment.meta.MulePolicyModel;
import org.mule.runtime.api.deployment.persistence.AbstractMuleArtifactModelJsonSerializer;
import org.mule.runtime.api.deployment.persistence.MulePolicyModelJsonSerializer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.artifact.DescriptorLoaderRepositoryFactory;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.AbstractArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptorValidatorBuilder;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DescriptorLoaderRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;

public class PolicyTemplateDescriptorFactory
extends AbstractArtifactDescriptorFactory<MulePolicyModel, PolicyTemplateDescriptor> {
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;

    public PolicyTemplateDescriptorFactory() {
        this(new ArtifactPluginDescriptorLoader(new ArtifactPluginDescriptorFactory()), new DescriptorLoaderRepositoryFactory().createDescriptorLoaderRepository(), ArtifactDescriptorValidatorBuilder.builder());
    }

    public PolicyTemplateDescriptorFactory(ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader, DescriptorLoaderRepository descriptorLoaderRepository, ArtifactDescriptorValidatorBuilder artifactDescriptorValidatorBuilder) {
        super(descriptorLoaderRepository, artifactDescriptorValidatorBuilder);
        Preconditions.checkArgument(artifactPluginDescriptorLoader != null, "artifactPluginDescriptorLoader cannot be null");
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
    }

    @Override
    protected void doDescriptorConfig(MulePolicyModel artifactModel, PolicyTemplateDescriptor descriptor, File artifactLocation) {
        descriptor.setRootFolder(artifactLocation);
        descriptor.setPlugins(this.parseArtifactPluginDescriptors(descriptor));
        descriptor.setSupportedJavaVersions(artifactModel.getSupportedJavaVersions());
    }

    private Set<ArtifactPluginDescriptor> parseArtifactPluginDescriptors(PolicyTemplateDescriptor descriptor) {
        Set pluginDependencies = descriptor.getClassLoaderConfiguration().getDependencies().stream().filter(dependency -> dependency.getDescriptor().isPlugin()).collect(Collectors.toSet());
        return pluginDependencies.stream().map(dependency -> {
            try {
                return this.artifactPluginDescriptorLoader.load(new File(dependency.getBundleUri()), dependency.getDescriptor(), descriptor);
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e);
            }
        }).collect(Collectors.toSet());
    }

    @Override
    protected AbstractMuleArtifactModelJsonSerializer<MulePolicyModel> getMuleArtifactModelJsonSerializer() {
        return new MulePolicyModelJsonSerializer();
    }

    @Override
    protected ArtifactType getArtifactType() {
        return ArtifactType.POLICY;
    }

    @Override
    protected PolicyTemplateDescriptor createArtifactDescriptor(File artifactLocation, String name, Optional<Properties> deploymentProperties) {
        return new PolicyTemplateDescriptor(name, deploymentProperties);
    }
}

