/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class ResourceExistsAndAccessible
implements Validation {
    private final ClassLoader artifactRegionClassLoader;

    public ResourceExistsAndAccessible(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
    }

    public final ClassLoader getArtifactRegionClassLoader() {
        return this.artifactRegionClassLoader;
    }

    @Override
    public String getName() {
        return "Resource exist and accessible";
    }

    @Override
    public String getDescription() {
        return "Artifact resources/files referenced in component parameters exist and are accessible.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getModel(ParameterizedModel.class).isPresent() && comp.getParameters().stream().anyMatch(p -> this.fixedValuePresent((ComponentParameterAst)p) && this.resourceParameter((ComponentParameterAst)p)));
    }

    protected final boolean fixedValuePresent(ComponentParameterAst p) {
        return p.getValue() != null && p.getValue().getRight() != null;
    }

    protected final boolean resourceParameter(ComponentParameterAst paramAst) {
        return paramAst.getModel().getDisplayModel().map(dm -> dm.getPathModel().map(pm -> !(!pm.getType().equals((Object)PathModel.Type.FILE) && !pm.getType().equals((Object)PathModel.Type.ANY) || !pm.getLocation().equals((Object)PathModel.Location.EMBEDDED) && !pm.getLocation().equals((Object)PathModel.Location.ANY))).orElse(false)).orElse(false);
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getParameters().stream().filter(p -> this.fixedValuePresent((ComponentParameterAst)p) && this.resourceParameter((ComponentParameterAst)p)).map(p -> {
            ComponentParameterAst parameter = component.getParameter(p.getGroupModel().getName(), p.getModel().getName());
            String resourceLocationValue = parameter.getValue().getRight().toString();
            return this.validateResourceExists(component, (ComponentParameterAst)p, resourceLocationValue);
        }).filter(Optional::isPresent).map(Optional::orElseThrow).collect(Collectors.toList());
    }

    protected final Optional<ValidationResultItem> validateResourceExists(ComponentAst component, ComponentParameterAst resourceParam, String resource) {
        if (this.getArtifactRegionClassLoader().getResource(resource) == null && !new File(resource).exists()) {
            return Optional.of(ValidationResultItem.create(component, resourceParam, (Validation)this, "Invalid configuration found for parameter '" + resourceParam.getModel().getName() + "': " + resource));
        }
        return Optional.empty();
    }
}

