/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.reflections.ReflectionUtils;

public final class LifecycleTransitionResult {
    private static void processAllNoRetry(Class<? extends Initialisable> iface, Iterator<? extends Initialisable> objects) throws LifecycleException {
        Class<?> exception;
        if (!iface.isAssignableFrom(Lifecycle.class)) {
            throw new IllegalArgumentException("Not a Lifecycle interface: " + String.valueOf(iface));
        }
        Set lifecycleMethodsCandidate = ReflectionUtils.getAllMethods(iface, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)"initialise")});
        Method method = lifecycleMethodsCandidate.isEmpty() ? null : (Method)lifecycleMethodsCandidate.iterator().next();
        boolean hasException = method.getExceptionTypes().length > 0;
        Class<?> clazz = exception = hasException ? method.getExceptionTypes()[0] : null;
        while (objects.hasNext()) {
            Initialisable target = objects.next();
            LifecycleTransitionResult.processSingleNoRetry(target, method, exception, iface);
        }
    }

    private static void processSingleNoRetry(Object target, Method method, Class<?> exception, Class<?> iface) throws LifecycleException {
        if (!iface.isAssignableFrom(target.getClass())) {
            throw new IllegalArgumentException(ClassUtils.getSimpleName(target.getClass()) + " is not an " + ClassUtils.getSimpleName(iface));
        }
        try {
            method.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unsupported interface: " + String.valueOf(iface)).initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Unsupported interface: " + String.valueOf(iface)).initCause(e);
        }
    }

    public static void initialiseAll(Iterator<? extends Initialisable> children) throws InitialisationException {
        try {
            LifecycleTransitionResult.processAllNoRetry(Initialisable.class, children);
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (LifecycleException e) {
            throw new IllegalStateException("Unexpected exception: ", e);
        }
    }
}

