/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.source;

import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.module.extension.internal.runtime.client.params.BaseComponentParameterizer;

class DefaultSourceParameterizer
extends BaseComponentParameterizer<SourceParameterizer>
implements SourceParameterizer {
    private BackPressureMode backPressureMode = BackPressureMode.WAIT;
    private SchedulingStrategy schedulingStrategy = null;

    DefaultSourceParameterizer() {
    }

    @Override
    public SourceParameterizer withBackPressureMode(BackPressureMode backPressureMode) {
        this.backPressureMode = backPressureMode;
        return this;
    }

    @Override
    public SourceParameterizer withFixedSchedulingStrategy(long frequency, TimeUnit timeUnit, long startDelay) {
        Preconditions.checkArgument(timeUnit != null, "timeUnit cannot be null");
        this.schedulingStrategy = new FixedFrequencyScheduler(frequency, startDelay, timeUnit);
        return this;
    }

    @Override
    public SourceParameterizer withCronSchedulingStrategy(String expression, String timeZone) {
        this.schedulingStrategy = new CronScheduler(expression, timeZone);
        return this;
    }

    @Override
    public <T extends ComponentModel> void setValuesOn(ComponentParameterization.Builder<T> builder) {
        super.setValuesOn(builder);
        if (this.schedulingStrategy != null) {
            builder.withParameter("schedulingStrategy", this.schedulingStrategy);
        }
    }

    public BackPressureMode getBackPressureMode() {
        return this.backPressureMode;
    }
}

