/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.discoverer;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.mule.runtime.module.service.api.discoverer.ServiceAssembly;
import org.mule.runtime.module.service.api.discoverer.ServiceResolutionError;
import org.mule.runtime.module.service.internal.discoverer.FileSystemServiceProviderDiscoverer;

public class LazyServiceAssembly
implements ServiceAssembly {
    private final String name;
    private final LazyValue<ClassLoader> classLoader;
    private final LazyValue<ServiceProvider> serviceProvider;
    private final String contractClassName;

    @Deprecated
    public static Builder builder() {
        return new Builder();
    }

    private LazyServiceAssembly(String name, Supplier<ClassLoader> classLoader, Supplier<ServiceProvider> serviceProvider, String contractClassName) {
        Preconditions.checkArgument(!StringUtils.isBlank(name), "name cannot be blank");
        Objects.requireNonNull(classLoader, "Classloader cannot be null");
        Objects.requireNonNull(serviceProvider, "ServiceProvider supplier cannot be null");
        Objects.requireNonNull(contractClassName, "satisfied contract cannot be null");
        this.name = name;
        this.classLoader = this.lazy(classLoader);
        this.serviceProvider = this.lazy(serviceProvider);
        this.contractClassName = contractClassName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceProvider getServiceProvider() {
        return this.serviceProvider.get();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader.get();
    }

    @Override
    public Class<? extends Service> getServiceContract() {
        return this.resolveContract();
    }

    private Class<? extends Service> resolveContract() {
        try {
            return ClassUtils.loadClass(this.contractClassName, FileSystemServiceProviderDiscoverer.class);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private <T> LazyValue<T> lazy(Supplier<T> supplier) {
        if (supplier instanceof LazyValue) {
            return (LazyValue)supplier;
        }
        return new LazyValue<Supplier<T>>(supplier);
    }

    public static class Builder
    implements ServiceAssembly.ServiceAssemblyBuilder {
        private String name;
        private Supplier<ClassLoader> artifactClassLoader;
        private Supplier<ServiceProvider> serviceProviderSupplier;
        private String contractClassName;

        private Builder() {
        }

        @Override
        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder withClassLoader(Supplier<ClassLoader> artifactClassLoader) {
            this.artifactClassLoader = artifactClassLoader;
            return this;
        }

        @Override
        public Builder withServiceProvider(CheckedSupplier<ServiceProvider> serviceProviderSupplier) {
            this.serviceProviderSupplier = serviceProviderSupplier;
            return this;
        }

        @Override
        public Builder forContract(String contractClassName) {
            this.contractClassName = contractClassName;
            return this;
        }

        @Override
        public ServiceAssembly build() throws ServiceResolutionError {
            try {
                return new LazyServiceAssembly(this.name, this.artifactClassLoader, this.serviceProviderSupplier, this.contractClassName);
            }
            catch (Exception e) {
                throw new ServiceResolutionError("Could not load service " + this.name, e);
            }
        }
    }
}

