/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.CustomOAuthParameters;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConfig;

public class PlatformManagedOAuthConfig
extends OAuthConfig<PlatformManagedOAuthGrantType> {
    private final String connectionUri;
    private final String serviceUrl;
    private final String platformAuthUrl;
    private final String clientId;
    private final String clientSecret;
    private final String orgId;
    private final String apiVersion;
    private final Charset encoding;
    private final PlatformManagedOAuthGrantType grantType;
    private final ExtensionModel extensionModel;
    private final ConnectionProviderModel delegateConnectionProviderModel;
    private final OAuthGrantType delegateGrantType;

    public static PlatformManagedOAuthConfig from(String ownerConfigName, String connectionUri, PlatformManagedOAuthGrantType grantType, ExtensionModel extensionModel, ConnectionProviderModel delegateConnectionProviderModel, OAuthGrantType delegateGrantType, ConfigurationProperties configurationProperties) {
        return new PlatformManagedOAuthConfig(ownerConfigName, connectionUri, PlatformManagedOAuthConfig.getProperty(configurationProperties, "ocs.service.url"), PlatformManagedOAuthConfig.resolvePlatformAuthUrl(configurationProperties), PlatformManagedOAuthConfig.getProperty(configurationProperties, "ocs.service.client.id"), PlatformManagedOAuthConfig.getProperty(configurationProperties, "ocs.service.client.secret"), PlatformManagedOAuthConfig.getProperty(configurationProperties, "csorganization.id"), PlatformManagedOAuthConfig.getProperty(configurationProperties, "ocs.api.version", false), StandardCharsets.UTF_8, grantType, extensionModel, delegateConnectionProviderModel, delegateGrantType);
    }

    private static String getProperty(ConfigurationProperties configurationProperties, String key, boolean isRequired) {
        if (isRequired) {
            return configurationProperties.resolveStringProperty(key).orElseThrow(() -> new IllegalArgumentException(String.format("OCS property '%s' has not been set", key)));
        }
        return configurationProperties.resolveStringProperty(key).orElse(null);
    }

    private static String getProperty(ConfigurationProperties configurationProperties, String key) {
        return PlatformManagedOAuthConfig.getProperty(configurationProperties, key, true);
    }

    private static String resolvePlatformAuthUrl(ConfigurationProperties configurationProperties) {
        return StringUtils.sanitizeUrl(PlatformManagedOAuthConfig.getProperty(configurationProperties, "ocs.platform.authentication.url")) + configurationProperties.resolveStringProperty("ocs.platform.authentication.path").orElse("/oauth2/token");
    }

    public PlatformManagedOAuthConfig(String ownerConfigName, String connectionUri, String serviceUrl, String platformAuthUrl, String clientId, String clientSecret, String orgId, String apiVersion, Charset encoding, PlatformManagedOAuthGrantType grantType, ExtensionModel extensionModel, ConnectionProviderModel delegateConnectionProviderModel, OAuthGrantType delegateGrantType) {
        super(ownerConfigName, Optional.empty(), new CustomOAuthParameters(), Collections.emptyMap());
        this.connectionUri = connectionUri;
        this.serviceUrl = serviceUrl;
        this.platformAuthUrl = platformAuthUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.orgId = orgId;
        this.apiVersion = apiVersion;
        this.encoding = encoding;
        this.grantType = grantType;
        this.extensionModel = extensionModel;
        this.delegateConnectionProviderModel = delegateConnectionProviderModel;
        this.delegateGrantType = delegateGrantType;
    }

    public String getConnectionUri() {
        return this.connectionUri;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getPlatformAuthUrl() {
        return this.platformAuthUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public ConnectionProviderModel getDelegateConnectionProviderModel() {
        return this.delegateConnectionProviderModel;
    }

    public OAuthGrantType getDelegateGrantType() {
        return this.delegateGrantType;
    }

    @Override
    public PlatformManagedOAuthGrantType getGrantType() {
        return this.grantType;
    }

    public ExtensionModel getExtensionModel() {
        return this.extensionModel;
    }
}

