/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence.metadata;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.mule.runtime.api.metadata.resolving.FailureCode;

public class FailureCodeTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (rawType.equals(FailureCode.class)) {
            return new TypeAdapter<FailureCode>(){

                public void write(JsonWriter out, FailureCode value) throws IOException {
                    if (value == null) {
                        out.nullValue();
                        return;
                    }
                    out.value(value.getName());
                }

                public FailureCode read(JsonReader in) throws IOException {
                    if (in.peek() == JsonToken.NULL) {
                        in.nextNull();
                        return null;
                    }
                    return new FailureCode(in.nextString());
                }
            };
        }
        return null;
    }
}

