/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.connection.ConnectionUtils;
import org.mule.runtime.module.extension.api.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.SdkConnectionProviderAdapter;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ValueSetter;

public abstract class BaseConnectionProviderObjectBuilder<C>
extends ResolverSetBasedObjectBuilder<Pair<ConnectionProvider<C>, ResolverSetResult>>
implements ConnectionProviderObjectBuilder<C> {
    protected final ConnectionProviderModel providerModel;
    protected final ReconnectionConfig reconnectionConfig;
    protected final PoolingProfile poolingProfile;
    protected final ExtensionModel extensionModel;
    protected final MuleContext muleContext;
    private volatile boolean firstBuild = true;
    protected String ownerConfigName;

    public BaseConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        this(providerModel, resolverSet, null, null, extensionModel, expressionManager, muleContext);
    }

    public BaseConnectionProviderObjectBuilder(Class<?> prototypeClass, ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(prototypeClass, providerModel, resolverSet, expressionManager, muleContext);
        this.providerModel = providerModel;
        this.poolingProfile = poolingProfile;
        this.extensionModel = Objects.requireNonNull(extensionModel);
        this.muleContext = muleContext;
        this.reconnectionConfig = this.computeReconnectionConfig(reconnectionConfig);
    }

    public BaseConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        this(MuleExtensionUtils.getConnectionProviderFactory(providerModel).getObjectType(), providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
    }

    private ReconnectionConfig computeReconnectionConfig(ReconnectionConfig reconnectionConfig) {
        return reconnectionConfig != null ? reconnectionConfig : ReconnectionConfig.defaultReconnectionConfig();
    }

    public BaseConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, Class<?> prototypeClass, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(prototypeClass, providerModel, resolverSet, expressionManager, muleContext);
        this.providerModel = providerModel;
        this.poolingProfile = poolingProfile;
        this.extensionModel = extensionModel;
        this.muleContext = muleContext;
        this.reconnectionConfig = this.computeReconnectionConfig(reconnectionConfig);
    }

    @Override
    protected Pair<ConnectionProvider<C>, ResolverSetResult> instantiateObject() {
        return new Pair(MuleExtensionUtils.getConnectionProviderFactory(this.providerModel).newInstance(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> build(ResolverSetResult result) throws MuleException {
        ConnectionProvider value = SdkConnectionProviderAdapter.from(((Pair)this.instantiateObject()).getFirst());
        Object injectionTarget = ConnectionUtils.getInjectionTarget(value);
        if (this.firstBuild) {
            BaseConnectionProviderObjectBuilder baseConnectionProviderObjectBuilder = this;
            synchronized (baseConnectionProviderObjectBuilder) {
                if (this.firstBuild) {
                    this.singleValueSetters = super.createSingleValueSetters(injectionTarget.getClass(), this.resolverSet);
                    this.firstBuild = false;
                }
            }
        }
        this.populate(result, injectionTarget);
        return new Pair(value, result);
    }

    @Override
    protected List<ValueSetter> createSingleValueSetters(Class<?> prototypeClass, ResolverSet resolverSet) {
        return Collections.emptyList();
    }

    @Override
    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }

    public void setOwnerConfigName(String ownerConfigName) {
        this.ownerConfigName = ownerConfigName;
    }
}

