/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.reader;

import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.mule.runtime.extension.internal.dsl.xml.XmlDslConstants;
import org.w3c.dom.Element;

public class ArtifactRootElement {
    private static final String DEFAULT_NAMESPACE_URI_MASK = "http://www.mulesoft.org/schema/mule/%s";
    private static final String DEFAULT_EE_NAMESPACE_URI_MASK = "http://www.mulesoft.org/schema/mule/ee/%s";
    private static final String CORE_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "core");
    private static final String DOMAIN_NAMESPACE = String.format("http://www.mulesoft.org/schema/mule/%s", "domain");
    private static final String DOMAIN_NAMESPACE_EE = String.format("http://www.mulesoft.org/schema/mule/ee/%s", "domain");
    private final String identifier;
    private final String namespace;
    private final String namespaceUri;

    public static ArtifactRootElement from(XmlApplicationParser parser, Element rootElement) {
        return new ArtifactRootElement(parser.parseIdentifier(rootElement), parser.parseNamespace(rootElement), parser.parseNamespaceUri(rootElement));
    }

    private ArtifactRootElement(String identifier, String namespace, String namespaceUri) {
        this.identifier = identifier;
        this.namespace = namespace;
        this.namespaceUri = namespaceUri;
    }

    public boolean isXmlSdkModule() {
        return this.namespace != null && this.namespace.equals("module") && this.namespaceUri != null && this.namespaceUri.equals(XmlDslConstants.MODULE_DSL_NAMESPACE_URI) && this.identifier != null && this.identifier.equals("module");
    }

    public ArtifactType resolveType() {
        if (this.namespaceUri != null && this.namespaceUri.equals(DOMAIN_NAMESPACE) && this.identifier != null && this.identifier.equals("mule-domain")) {
            return ArtifactType.DOMAIN;
        }
        if (this.namespaceUri != null && this.namespaceUri.equals(DOMAIN_NAMESPACE_EE) && this.identifier != null && this.identifier.equals("mule-domain")) {
            return ArtifactType.DOMAIN;
        }
        if (this.namespaceUri != null && this.namespaceUri.equals(CORE_NAMESPACE) && this.identifier != null && this.identifier.equals("mule")) {
            return ArtifactType.APPLICATION;
        }
        return null;
    }
}

