/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.lazy;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.core.api.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class TrackingPostProcessor
implements BeanPostProcessor {
    private final Set<String> trackingOrderedSet = new LinkedHashSet<String>();
    private final Set<String> currentTrackingOrderedSet = new LinkedHashSet<String>();
    private boolean tracking = false;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.tracking) {
            StringUtils.ifNotBlank(beanName, this.currentTrackingOrderedSet::add);
        }
        return bean;
    }

    public Set<String> getBeansTracked() {
        return ImmutableSet.copyOf(this.trackingOrderedSet);
    }

    public List<String> getBeansTrackedInOrder() {
        return ImmutableList.copyOf(this.trackingOrderedSet);
    }

    public void startTracking() {
        this.tracking = true;
        this.currentTrackingOrderedSet.clear();
    }

    public void stopTracking() {
        this.tracking = false;
        this.currentTrackingOrderedSet.clear();
    }

    public void commitOnly(Collection<String> beanNames) {
        this.tracking = false;
        this.currentTrackingOrderedSet.stream().filter(beanNames::contains).forEach(this.trackingOrderedSet::add);
        this.currentTrackingOrderedSet.clear();
    }

    public void reset() {
        this.trackingOrderedSet.clear();
        this.currentTrackingOrderedSet.clear();
        this.tracking = false;
    }
}

