/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.xs.StringList;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObject;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.xml.api.handler.XmlHandler;
import org.mule.metadata.xml.api.utils.XmlConstants;
import org.mule.metadata.xml.internal.utils.SchemaHelper;

public class StringHandler
implements XmlHandler {
    public static final List<QName> STRING_TYPES = Arrays.asList(XmlConstants.XSD_STRING, XmlConstants.XSD_ANY, XmlConstants.XSD_NORMALIZEDSTRING);

    @Override
    public boolean handles(QName schema) {
        return STRING_TYPES.contains(schema);
    }

    @Override
    public TypeBuilder<?> handle(XSSimpleTypeDecl element, Optional<String> defaultValue, BaseTypeBuilder builder) {
        StringTypeBuilder stringType = builder.stringType();
        StringList enumeration = element.getLexicalEnumeration();
        if (!enumeration.isEmpty()) {
            String[] values = enumeration.toArray(new String[enumeration.size()]);
            stringType.enumOf(values);
        } else {
            XSMultiValueFacet patternFacet;
            StringList lexicalFacetValues;
            XSObject patternFacetObject;
            if (defaultValue.isPresent() && !defaultValue.get().isEmpty()) {
                stringType.defaultValue(defaultValue.get());
            }
            if ((patternFacetObject = SchemaHelper.getFacet(element, 8)) instanceof XSMultiValueFacet && (lexicalFacetValues = (patternFacet = (XSMultiValueFacet)patternFacetObject).getLexicalFacetValues()) != null && !lexicalFacetValues.isEmpty()) {
                stringType.pattern(lexicalFacetValues.item(0));
            }
            Optional<Integer> minLength = Optional.ofNullable(SchemaHelper.getFacet(element, 2)).map(SchemaHelper::getIntegerValue);
            Optional<Integer> maxLength = Optional.ofNullable(SchemaHelper.getFacet(element, 4)).map(SchemaHelper::getIntegerValue);
            if (minLength.isPresent() || maxLength.isPresent()) {
                stringType.boundary(minLength.orElse(null), maxLength.orElse(null));
            }
            Optional<Integer> length = Optional.ofNullable(SchemaHelper.getFacet(element, 1)).map(SchemaHelper::getIntegerValue);
            length.ifPresent(stringType::length);
        }
        return stringType;
    }
}

