/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.el.ExpressionLanguageUtils;
import org.mule.runtime.core.internal.exception.MessagingExceptionResolver;
import org.mule.runtime.core.internal.processor.AbstractRedeliveryPolicy;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.features.api.MuleRuntimeFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class IdempotentRedeliveryPolicy
extends AbstractRedeliveryPolicy {
    private static final String EXPRESSION_RUNTIME_EXCEPTION_ERROR_MSG = "The message cannot be processed because the digest could not be generated. Either make the payload serializable or use an expression.";
    private static final String BLANK_MESSAGE_ID_ERROR_MSG = "The message cannot be processed because the message ID is null or blank.";
    public static final String SECURE_HASH_EXPR_FORMAT = "%%dw 2.0\noutput text/plain\nimport dw::Crypto\n---\nif ((payload.^mimeType startsWith 'application/java') and payload.^class != 'java.lang.String')\njava!java::util::Objects::hashCode(payload)\nelse\nCrypto::hashWith(payload.^raw, '%s')\n";
    public static final String ENCODED_SECURE_HASH_EXPR_FORMAT = "%%dw 2.0\noutput text/plain\nimport dw::Crypto\nimport dw::core::Binaries\n---\nBinaries::toHex(\nif ((payload.^mimeType startsWith 'application/java') and payload.^class != 'java.lang.String')\njava!java::util::Objects::hashCode(payload)\nelse\nCrypto::hashWith(payload.^raw, '%s')\n)";
    private static final Logger LOGGER = LoggerFactory.getLogger(IdempotentRedeliveryPolicy.class);
    private final MessagingExceptionResolver exceptionResolver = new MessagingExceptionResolver(this);
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private LockFactory lockFactory;
    private ObjectStoreManager objectStoreManager;
    private ExpressionManager expressionManager;
    private boolean useSecureHash;
    private String messageDigestAlgorithm;
    private String idExpression;
    private CompiledExpression compiledIdExpresion;
    private ObjectStore<RedeliveryCounter> store;
    private ObjectStore<RedeliveryCounter> privateStore;
    private String idrId;
    private boolean isOwnedObjectStore;

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.initialiseExpression();
        this.initialiseStore();
    }

    private void initialiseExpression() throws InitialisationException {
        if (this.useSecureHash && this.idExpression != null) {
            this.useSecureHash = false;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Disabling useSecureHash in idempotent-redelivery-policy since an idExpression has been configured");
            }
        }
        if (!this.useSecureHash && this.messageDigestAlgorithm != null) {
            throw new InitialisationException(CoreMessages.initialisationFailure(String.format("The message digest algorithm '%s' was specified when a secure hash will not be used", this.messageDigestAlgorithm)), (Initialisable)this);
        }
        if (!this.useSecureHash && this.idExpression == null) {
            throw new InitialisationException(CoreMessages.initialisationFailure("No method for identifying messages was specified"), (Initialisable)this);
        }
        if (this.useSecureHash) {
            if (this.messageDigestAlgorithm == null) {
                this.messageDigestAlgorithm = "SHA-256";
            }
            this.idExpression = String.format(this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_REDELIVERY_POLICY_ENCODE_SECURE_HASH) ? ENCODED_SECURE_HASH_EXPR_FORMAT : SECURE_HASH_EXPR_FORMAT, this.messageDigestAlgorithm);
        }
        if (this.idExpression != null) {
            this.compiledIdExpresion = ExpressionLanguageUtils.compile(this.idExpression, this.expressionManager);
        }
    }

    private void initialiseStore() throws InitialisationException {
        this.idrId = String.format("%s-%s-%s", this.muleContext.getConfiguration().getId(), this.getLocation().getRootContainerName(), "idr");
        boolean bl = this.isOwnedObjectStore = this.privateStore != null || this.store == null;
        if (this.store != null && this.privateStore != null) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("Ambiguous definition of object store, both reference and private were configured"), (Initialisable)this);
        }
        if (this.store == null) {
            this.store = this.privateStore == null ? this.createInternalObjectStore() : this.privateStore;
        }
        if (this.isOwnedObjectStore) {
            LifecycleUtils.initialiseIfNeeded(this.store, true, this.muleContext);
        }
    }

    private ObjectStore<RedeliveryCounter> createInternalObjectStore() {
        return this.objectStoreManager.createObjectStore(this.getObjectStoreName(), ObjectStoreSettings.builder().persistent(false).entryTtl(300000L).expirationInterval(6000L).build());
    }

    @Override
    public void dispose() {
        if (this.isOwnedObjectStore) {
            this.disposeStore();
        }
        super.dispose();
    }

    private void disposeStore() {
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (ObjectStoreException e) {
                LOGGER.warn("error closing object store: " + e.getMessage(), (Throwable)e);
            }
            try {
                this.objectStoreManager.disposeStore(this.getObjectStoreName());
            }
            catch (ObjectStoreException e) {
                LOGGER.warn("error disposing object store: " + e.getMessage(), (Throwable)e);
            }
            this.store = null;
        }
    }

    @Override
    public void start() throws MuleException {
        super.start();
        if (this.isOwnedObjectStore) {
            LifecycleUtils.startIfNeeded(this.store);
        }
    }

    @Override
    public void stop() throws MuleException {
        if (this.isOwnedObjectStore) {
            LifecycleUtils.stopIfNeeded(this.store);
        }
        super.stop();
    }

    /*
     * Exception decompiling
     */
    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        return ReactiveProcessor.ProcessingType.BLOCKING;
    }

    private MessagingException createMessagingException(CoreEvent event, Throwable cause) {
        return this.exceptionResolver.resolve(new MessagingException(event, cause, (Component)this), this.errorTypeLocator, this.exceptionContextProviders);
    }

    private void resetCounter(String messageId) throws ObjectStoreException {
        this.store.remove(messageId);
        this.store.store(messageId, new RedeliveryCounter(new AtomicInteger(), new LinkedList<Error>()));
    }

    public RedeliveryCounter findCounter(String messageId) throws ObjectStoreException {
        boolean counterExists = this.store.contains(messageId);
        if (counterExists) {
            return this.store.retrieve(messageId);
        }
        return null;
    }

    private RedeliveryCounter incrementCounter(String messageId, MessagingException ex) throws ObjectStoreException {
        RedeliveryCounter counter = this.findCounter(messageId);
        if (counter == null) {
            counter = new RedeliveryCounter(new AtomicInteger(), new LinkedList<Error>());
        } else {
            this.store.remove(messageId);
        }
        counter.counter.incrementAndGet();
        ex.getEvent().getError().ifPresent(counter.errors::add);
        this.store.store(messageId, counter);
        return counter;
    }

    private String getIdForEvent(CoreEvent event) {
        try (ExpressionManagerSession session = this.expressionManager.openSession(event.asBindingContext());){
            String string = (String)session.evaluate(this.compiledIdExpresion, DataType.STRING).getValue();
            return string;
        }
    }

    public boolean isUseSecureHash() {
        return this.useSecureHash;
    }

    public void setUseSecureHash(boolean useSecureHash) {
        this.useSecureHash = useSecureHash;
    }

    public String getMessageDigestAlgorithm() {
        return this.messageDigestAlgorithm;
    }

    public void setMessageDigestAlgorithm(String messageDigestAlgorithm) {
        this.messageDigestAlgorithm = messageDigestAlgorithm;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public void setIdExpression(String idExpression) {
        this.idExpression = idExpression;
    }

    public void setObjectStore(ObjectStore<RedeliveryCounter> store) {
        this.store = store;
    }

    public void setPrivateObjectStore(ObjectStore<RedeliveryCounter> store) {
        this.privateStore = store;
    }

    @Inject
    public void setLockFactory(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    @Inject
    @Named(value="_muleObjectStoreManager")
    public void setObjectStoreManager(ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    @Inject
    public void setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }

    private String getObjectStoreName() {
        return this.getLocation().getRootContainerName() + "." + this.getClass().getName();
    }

    public static class RedeliveryCounter
    implements Serializable {
        private static final long serialVersionUID = 5513487261745816555L;
        private final AtomicInteger counter;
        private final List<Error> errors;

        public RedeliveryCounter(AtomicInteger counter, List<Error> errors) {
            this.counter = counter;
            this.errors = errors;
        }

        public AtomicInteger getCounter() {
            return this.counter;
        }

        public List<Error> getErrors() {
            return this.errors;
        }
    }
}

