/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.lifecycle;

import java.util.Arrays;
import java.util.stream.Stream;
import org.mule.runtime.core.internal.util.CompositeClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactDisposalContext
implements ArtifactDisposalContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactDisposalContext.class);
    private final ArtifactClassLoader artifactClassLoader;
    private final ArtifactClassLoader extensionClassLoader;

    public DefaultArtifactDisposalContext(ArtifactClassLoader artifactClassLoader, ArtifactClassLoader extensionClassLoader) {
        this.artifactClassLoader = artifactClassLoader;
        this.extensionClassLoader = extensionClassLoader;
    }

    @Override
    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader.getClassLoader();
    }

    @Override
    public ClassLoader getArtifactClassLoader() {
        return this.artifactClassLoader.getClassLoader();
    }

    @Override
    public boolean isExtensionOwnedClassLoader(ClassLoader classLoader) {
        return this.isOwnedClassLoader(this.extensionClassLoader, classLoader);
    }

    @Override
    public boolean isArtifactOwnedClassLoader(ClassLoader classLoader) {
        return this.isOwnedClassLoader(this.artifactClassLoader, classLoader);
    }

    @Override
    public Stream<Thread> getExtensionOwnedThreads() {
        return this.getAllThreads().filter(this::isExtensionOwnedThread);
    }

    @Override
    public Stream<Thread> getArtifactOwnedThreads() {
        return this.getAllThreads().filter(this::isArtifactOwnedThread);
    }

    @Override
    public boolean isExtensionOwnedThread(Thread thread) {
        return this.isExtensionOwnedClassLoader(thread.getContextClassLoader());
    }

    @Override
    public boolean isArtifactOwnedThread(Thread thread) {
        return this.isArtifactOwnedClassLoader(thread.getContextClassLoader());
    }

    private boolean isOwnedClassLoader(ArtifactClassLoader ownerClassLoader, ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader == ownerClassLoader.getClassLoader()) {
                return true;
            }
            if (classLoader instanceof CompositeClassLoader) {
                for (ClassLoader delegate : ((CompositeClassLoader)classLoader).getDelegates()) {
                    if (!this.isOwnedClassLoader(ownerClassLoader, delegate)) continue;
                    return true;
                }
            }
            classLoader = classLoader.getParent();
        }
        return false;
    }

    private ThreadGroup getTopLevelThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            try {
                threadGroup = threadGroup.getParent();
            }
            catch (SecurityException e) {
                LOGGER.debug(String.format("An error occurred trying to obtain the active Threads for artifact [%s], and extension [%s]. Parent Thread Group is not accessible. Some threads may not be cleaned up.", this.artifactClassLoader.getArtifactId(), this.extensionClassLoader.getArtifactId()), (Throwable)e);
                return threadGroup;
            }
        }
        return threadGroup;
    }

    private Stream<Thread> getAllThreads() {
        try {
            ThreadGroup threadGroup = this.getTopLevelThreadGroup();
            Thread[] allThreads = new Thread[threadGroup.activeCount()];
            threadGroup.enumerate(allThreads);
            return Arrays.stream(allThreads);
        }
        catch (SecurityException e) {
            LOGGER.warn(String.format("An error occurred trying to obtain the active Threads for artifact [%s], and extension [%s]. Thread cleanup will be skipped.", this.artifactClassLoader.getArtifactId(), this.extensionClassLoader.getArtifactId()), (Throwable)e);
            return Stream.empty();
        }
    }
}

